/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.model.request.base.StatusUpdateRequest;
import com.aizuda.snailjob.server.service.service.RetryService;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.BatchDeleteRetryTaskVO;
import com.aizuda.snailjob.server.web.model.request.BatchUpdateRetryStatusVO;
import com.aizuda.snailjob.server.web.model.request.GenerateRetryIdempotentIdVO;
import com.aizuda.snailjob.server.web.model.request.ManualTriggerTaskRequestVO;
import com.aizuda.snailjob.server.web.model.request.ParseLogsVO;
import com.aizuda.snailjob.server.web.model.request.RetryQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetrySaveRequestVO;
import com.aizuda.snailjob.server.web.model.request.RetryUpdateExecutorNameRequestVO;
import com.aizuda.snailjob.server.web.model.request.StatusUpdateRequestWebVO;
import com.aizuda.snailjob.server.web.model.response.RetryResponseWebVO;
import com.aizuda.snailjob.server.web.service.RetryWebService;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/retry"})
public class RetryController {
    private final RetryWebService retryWebService;
    @Qualifier(value="retryWebCommonService")
    private final RetryService retryService;

    @LoginRequired
    @GetMapping(value={"list"})
    public PageResult<List<RetryResponseWebVO>> getRetryTaskPage(RetryQueryVO queryVO) {
        return this.retryWebService.getRetryPage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public RetryResponseWebVO getRetryTaskById(@PathVariable(value="id") Long id) {
        return (RetryResponseWebVO)this.retryService.getRetryById(id, RetryResponseWebVO.class);
    }

    @LoginRequired
    @PutMapping(value={"status"})
    public boolean updateRetryTaskStatus(@RequestBody StatusUpdateRequestWebVO retryUpdateStatusRequestVO) {
        return this.retryService.updateRetryStatus((StatusUpdateRequest)retryUpdateStatusRequestVO);
    }

    @LoginRequired
    @PostMapping
    public int saveRetryTask(@RequestBody @Validated RetrySaveRequestVO retryTaskRequestVO) {
        return this.retryWebService.saveRetryTask(retryTaskRequestVO);
    }

    @LoginRequired
    @PostMapping(value={"/generate/idempotent-id"})
    public Result<String> idempotentIdGenerate(@RequestBody @Validated GenerateRetryIdempotentIdVO generateRetryIdempotentIdVO) {
        return new Result((Object)this.retryWebService.idempotentIdGenerate(generateRetryIdempotentIdVO));
    }

    @LoginRequired
    @PutMapping(value={"/batch"})
    public Integer updateRetryTaskExecutorName(@RequestBody @Validated RetryUpdateExecutorNameRequestVO requestVO) {
        return this.retryWebService.updateRetryExecutorName(requestVO);
    }

    @LoginRequired
    @DeleteMapping(value={"/batch"})
    public boolean batchDeleteRetry(@RequestBody @Validated BatchDeleteRetryTaskVO requestVO) {
        return this.retryWebService.batchDeleteRetry(requestVO);
    }

    @LoginRequired
    @PutMapping(value={"/batchUpdateRetryStatus"})
    public Integer batchUpdateRetryStatus(@RequestBody @Validated BatchUpdateRetryStatusVO requestVO) {
        return this.retryWebService.batchUpdateRetryStatus(requestVO);
    }

    @LoginRequired
    @PostMapping(value={"/batch"})
    public Integer parseLogs(@RequestBody @Validated ParseLogsVO parseLogsVO) {
        return this.retryWebService.parseLogs(parseLogsVO);
    }

    @LoginRequired
    @PostMapping(value={"/manual/trigger/retry/task"})
    public boolean manualTriggerRetryTask(@RequestBody @Validated ManualTriggerTaskRequestVO requestVO) {
        return this.retryWebService.manualTriggerRetryTask(requestVO);
    }

    @Generated
    public RetryController(RetryWebService retryWebService, @Qualifier(value="retryWebCommonService") RetryService retryService) {
        this.retryWebService = retryWebService;
        this.retryService = retryService;
    }
}

