/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.model.request.GenerateRetryIdempotentIdRequest;
import com.aizuda.snailjob.model.request.RetryTaskRequest;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.InstanceSelectCondition;
import com.aizuda.snailjob.server.common.enums.RetryTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.enums.TaskGeneratorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.convert.RetryConverter;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskPrepareDTO;
import com.aizuda.snailjob.server.retry.task.support.generator.retry.TaskContext;
import com.aizuda.snailjob.server.retry.task.support.generator.retry.TaskGenerator;
import com.aizuda.snailjob.server.service.service.impl.AbstractRetryService;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.BatchDeleteRetryTaskVO;
import com.aizuda.snailjob.server.web.model.request.GenerateRetryIdempotentIdVO;
import com.aizuda.snailjob.server.web.model.request.ManualTriggerTaskRequestVO;
import com.aizuda.snailjob.server.web.model.request.ParseLogsVO;
import com.aizuda.snailjob.server.web.model.request.RetryQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetrySaveRequestVO;
import com.aizuda.snailjob.server.web.model.request.RetryUpdateExecutorNameRequestVO;
import com.aizuda.snailjob.server.web.model.response.RetryResponseWebVO;
import com.aizuda.snailjob.server.web.service.RetryWebService;
import com.aizuda.snailjob.server.web.service.convert.RetryTaskResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.TaskContextConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateUpdateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="retryWebCommonService")
public class RetryWebServiceImpl
extends AbstractRetryService
implements RetryWebService {
    private final RetryTaskMapper retryTaskMapper;
    private final AccessTemplate accessTemplate;
    private final List<TaskGenerator> taskGenerators;
    private final RetryTaskLogMessageMapper retryTaskLogMessageMapper;
    private final TransactionTemplate transactionTemplate;
    private final InstanceManager instanceManager;

    @Override
    public PageResult<List<RetryResponseWebVO>> getRetryPage(RetryQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), Retry::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), Retry::getSceneName, (Object)queryVO.getSceneName())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getBizNo()), Retry::getBizNo, (Object)queryVO.getBizNo())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId()), Retry::getIdempotentId, (Object)queryVO.getIdempotentId())).eq(Objects.nonNull(queryVO.getRetryId()), Retry::getId, (Object)queryVO.getRetryId())).eq(Objects.nonNull(queryVO.getRetryStatus()), Retry::getRetryStatus, (Object)queryVO.getRetryStatus())).eq(Retry::getTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).select(new SFunction[]{Retry::getId, Retry::getBizNo, Retry::getIdempotentId, Retry::getGroupName, Retry::getNextTriggerAt, Retry::getRetryCount, Retry::getRetryStatus, CreateUpdateDt::getUpdateDt, CreateDt::getCreateDt, Retry::getSceneName, Retry::getTaskType, Retry::getParentId}).orderByDesc(CreateDt::getCreateDt);
        pageDTO = this.accessTemplate.getRetryAccess().listPage(pageDTO, queryWrapper);
        Set ids = StreamUtils.toSet((Collection)pageDTO.getRecords(), Retry::getId);
        Map callbackMap = Maps.newHashMap();
        if (CollUtil.isNotEmpty((Collection)ids)) {
            List callbackTaskList = this.accessTemplate.getRetryAccess().list((LambdaQueryWrapper)new LambdaQueryWrapper().in(Retry::getParentId, (Collection)ids));
            callbackMap = StreamUtils.toIdentityMap((Collection)callbackTaskList, Retry::getParentId);
        }
        List<RetryResponseWebVO> retryResponseList = RetryTaskResponseVOConverter.INSTANCE.convertList(pageDTO.getRecords());
        for (RetryResponseWebVO retryResponseWebVO : retryResponseList) {
            RetryResponseWebVO responseVO = RetryTaskResponseVOConverter.INSTANCE.convert((Retry)callbackMap.get(retryResponseWebVO.getId()));
            if (Objects.isNull((Object)responseVO)) {
                retryResponseWebVO.setChildren(Lists.newArrayList());
                continue;
            }
            retryResponseWebVO.setChildren(Lists.newArrayList((Object[])new RetryResponseWebVO[]{responseVO}));
        }
        return new PageResult<List<RetryResponseWebVO>>(pageDTO, retryResponseList);
    }

    @Override
    public int saveRetryTask(RetrySaveRequestVO retryTaskRequestVO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)retryTaskRequestVO.getRetryStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new SnailJobServerException("Retry status error");
        }
        TaskGenerator taskGenerator = this.taskGenerators.stream().filter(t -> t.supports(TaskGeneratorSceneEnum.MANA_SINGLE.getScene())).findFirst().orElseThrow(() -> new SnailJobServerException("No matching task generator found"));
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskContext taskContext = new TaskContext();
        taskContext.setSceneName(retryTaskRequestVO.getSceneName());
        taskContext.setGroupName(retryTaskRequestVO.getGroupName());
        taskContext.setInitStatus(retryTaskRequestVO.getRetryStatus());
        taskContext.setNamespaceId(namespaceId);
        taskContext.setTaskInfos(Collections.singletonList(TaskContextConverter.INSTANCE.convert(retryTaskRequestVO)));
        taskGenerator.taskGenerator(taskContext);
        return 1;
    }

    @Override
    public String idempotentIdGenerate(GenerateRetryIdempotentIdVO generateRetryIdempotentIdVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(generateRetryIdempotentIdVO.getGroupName(), generateRetryIdempotentIdVO.getSceneName(), namespaceId);
        Assert.notNull((Object)retrySceneConfig, () -> new SnailJobServerException("Failed to generate idempotentId: RetrySceneConfig nodes exist"));
        InstanceSelectCondition condition = InstanceSelectCondition.builder().allocKey(retrySceneConfig.getSceneName()).groupName(retrySceneConfig.getGroupName()).namespaceId(retrySceneConfig.getNamespaceId()).routeKey(retrySceneConfig.getRouteKey()).targetLabels(retrySceneConfig.getLabels()).build();
        InstanceLiveInfo instance = this.instanceManager.getALiveInstanceByRouteKey(condition);
        Assert.notNull((Object)instance, () -> new SnailJobServerException("Failed to generate idempotentId: No active client nodes exist"));
        GenerateRetryIdempotentIdRequest generateRetryIdempotentIdRequest = new GenerateRetryIdempotentIdRequest();
        generateRetryIdempotentIdRequest.setGroup(generateRetryIdempotentIdVO.getGroupName());
        generateRetryIdempotentIdRequest.setScene(generateRetryIdempotentIdVO.getSceneName());
        generateRetryIdempotentIdRequest.setArgsStr(generateRetryIdempotentIdVO.getArgsStr());
        generateRetryIdempotentIdRequest.setExecutorName(generateRetryIdempotentIdVO.getExecutorName());
        generateRetryIdempotentIdRequest.setSerializerName(generateRetryIdempotentIdVO.getSerializerName());
        RetryRpcClient rpcClient = (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(instance).retryTimes(3).failover(false).failRetry(true).retryInterval(1).client(RetryRpcClient.class).build();
        Result result = rpcClient.generateIdempotentId(generateRetryIdempotentIdRequest);
        Assert.notNull((Object)result, () -> new SnailJobServerException("idempotentId generation failed"));
        Assert.isTrue((1 == result.getStatus() ? 1 : 0) != 0, () -> new SnailJobServerException("idempotentId generation failed: Ensure that the parameters and executor name are correct"));
        return (String)result.getData();
    }

    @Override
    public int updateRetryExecutorName(RetryUpdateExecutorNameRequestVO requestVO) {
        Retry retry = new Retry();
        retry.setExecutorName(requestVO.getExecutorName());
        retry.setRetryStatus(requestVO.getRetryStatus());
        retry.setUpdateDt(LocalDateTime.now());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryAccess();
        return retryTaskAccess.update((Object)retry, (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(Retry::getNamespaceId, (Object)namespaceId)).eq(Retry::getGroupName, (Object)requestVO.getGroupName())).in(Retry::getId, requestVO.getIds()));
    }

    @Override
    @Transactional
    public boolean batchDeleteRetry(BatchDeleteRetryTaskVO requestVO) {
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryAccess();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List retries = retryTaskAccess.list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getNamespaceId, (Object)namespaceId)).eq(Retry::getGroupName, (Object)requestVO.getGroupName())).in(Retry::getRetryStatus, (Collection)RetryStatusEnum.ALLOW_DELETE_STATUS)).in(Retry::getId, requestVO.getIds()));
        Assert.notEmpty((Iterable)retries, () -> new SnailJobServerException("No deletable data, only non-[Processing] data can be deleted"));
        Set retryIds = StreamUtils.toSet((Collection)retries, Retry::getId);
        this.retryTaskMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getGroupName, (Object)requestVO.getGroupName())).eq(RetryTask::getNamespaceId, (Object)namespaceId)).in(RetryTask::getRetryId, (Collection)retryIds));
        this.retryTaskLogMessageMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getGroupName, (Object)requestVO.getGroupName())).in(RetryTaskLogMessage::getRetryId, (Collection)retryIds));
        Assert.isTrue((requestVO.getIds().size() == retryTaskAccess.delete((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getNamespaceId, (Object)namespaceId)).eq(Retry::getGroupName, (Object)requestVO.getGroupName())).in(Retry::getRetryStatus, (Collection)RetryStatusEnum.ALLOW_DELETE_STATUS)).in(Retry::getId, requestVO.getIds())) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete retry task, please check if the task status is completed or at maximum attempts"));
        return Boolean.TRUE;
    }

    @Override
    public Integer parseLogs(ParseLogsVO parseLogsVO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)parseLogsVO.getRetryStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new SnailJobServerException("Retry status error");
        }
        String logStr = parseLogsVO.getLogStr();
        String patternString = "<\\|>(.*?)<\\|>";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(logStr);
        ArrayList waitInsertList = new ArrayList();
        while (matcher.find()) {
            List retryTaskList;
            String extractedData = matcher.group(1);
            if (StrUtil.isBlank((CharSequence)extractedData) || !CollUtil.isNotEmpty((Collection)(retryTaskList = JsonUtil.parseList((String)extractedData, RetryTaskRequest.class)))) continue;
            waitInsertList.addAll(retryTaskList);
        }
        Assert.isFalse((boolean)waitInsertList.isEmpty(), () -> new SnailJobServerException("No matching data found"));
        Assert.isTrue((waitInsertList.size() <= 500 ? 1 : 0) != 0, () -> new SnailJobServerException("A maximum of 500 data entries can be processed"));
        TaskGenerator taskGenerator = this.taskGenerators.stream().filter(t -> t.supports(TaskGeneratorSceneEnum.MANA_BATCH.getScene())).findFirst().orElseThrow(() -> new SnailJobServerException("No matching task generator found"));
        boolean allMatch = waitInsertList.stream().allMatch(retryTaskDTO -> retryTaskDTO.getGroupName().equals(parseLogsVO.getGroupName()));
        Assert.isTrue((boolean)allMatch, () -> new SnailJobServerException("Data groupName mismatch, please check your data"));
        Map map = StreamUtils.groupByKey(waitInsertList, RetryTaskRequest::getSceneName);
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        this.transactionTemplate.execute(status -> {
            map.forEach((sceneName, retryTaskDTOS) -> {
                TaskContext taskContext = new TaskContext();
                taskContext.setSceneName(sceneName);
                taskContext.setGroupName(parseLogsVO.getGroupName());
                taskContext.setNamespaceId(namespaceId);
                taskContext.setInitStatus(parseLogsVO.getRetryStatus());
                taskContext.setTaskInfos(TaskContextConverter.INSTANCE.convert((List<RetryTaskRequest>)retryTaskDTOS));
                try {
                    taskGenerator.taskGenerator(taskContext);
                }
                catch (DuplicateKeyException e) {
                    throw new SnailJobServerException("namespaceId:[{}] groupName:[{}] sceneName:[{}] Task already exists", new Object[]{namespaceId, parseLogsVO.getGroupName(), sceneName});
                }
            });
            return Boolean.TRUE;
        });
        return waitInsertList.size();
    }

    @Override
    public boolean manualTriggerRetryTask(ManualTriggerTaskRequestVO requestVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)requestVO.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("Group [{}] is closed, manual execution is not supported.", new Object[]{requestVO.getGroupName()}));
        List<Long> retryIds = requestVO.getRetryIds();
        List list = this.accessTemplate.getRetryAccess().list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getNamespaceId, (Object)namespaceId)).eq(Retry::getTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).in(Retry::getId, retryIds));
        Assert.notEmpty((Iterable)list, () -> new SnailJobServerException("No executable tasks"));
        for (Retry retry : list) {
            RetryTaskPrepareDTO retryTaskPrepareDTO = RetryConverter.INSTANCE.toRetryTaskPrepareDTO(retry);
            retryTaskPrepareDTO.setNextTriggerAt(Long.valueOf(DateUtils.toNowMilli()));
            retryTaskPrepareDTO.setRetryTaskExecutorScene(Integer.valueOf(RetryTaskExecutorSceneEnum.MANUAL_RETRY.getScene()));
            retryTaskPrepareDTO.setRetryId(retry.getId());
            ActorRef actorRef = ActorGenerator.retryTaskPrepareActor();
            actorRef.tell((Object)retryTaskPrepareDTO, actorRef);
        }
        return true;
    }

    protected String getNamespaceId() {
        return UserSessionUtils.currentUserSession().getNamespaceId();
    }

    @Generated
    public RetryWebServiceImpl(RetryTaskMapper retryTaskMapper, AccessTemplate accessTemplate, List<TaskGenerator> taskGenerators, RetryTaskLogMessageMapper retryTaskLogMessageMapper, TransactionTemplate transactionTemplate, InstanceManager instanceManager) {
        this.retryTaskMapper = retryTaskMapper;
        this.accessTemplate = accessTemplate;
        this.taskGenerators = taskGenerators;
        this.retryTaskLogMessageMapper = retryTaskLogMessageMapper;
        this.transactionTemplate = transactionTemplate;
        this.instanceManager = instanceManager;
    }
}

