/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjUtil;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.service.service.impl.AbstractJobBatchService;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.JobBatchQueryVO;
import com.aizuda.snailjob.server.web.model.request.JobBatchResponseWebVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.service.JobWebBatchService;
import com.aizuda.snailjob.server.web.service.convert.JobBatchResponseVOConverter;
import com.aizuda.snailjob.server.web.service.handler.JobHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jobWebBatchCommonService")
public class JobWebBatchServiceImpl
extends AbstractJobBatchService
implements JobWebBatchService {
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobHandler jobHandler;

    @Override
    public PageResult<List<JobBatchResponseWebVO>> getJobBatchPage(JobBatchQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        if (userSessionVO.isUser() && CollUtil.isEmpty(groupNames)) {
            return new PageResult<List<JobBatchResponseWebVO>>(pageDTO, Collections.emptyList());
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"batch.namespace_id", (Object)userSessionVO.getNamespaceId())).eq((Object)"batch.system_task_type", (Object)SyetemTaskTypeEnum.JOB.getType())).eq(queryVO.getJobId() != null, (Object)"batch.job_id", (Object)queryVO.getJobId())).in(CollUtil.isNotEmpty(groupNames), (Object)"batch.group_name", groupNames)).in(ObjUtil.isNotEmpty(queryVO.getTaskBatchStatus()), (Object)"batch.task_batch_status", queryVO.getTaskBatchStatus())).between(ObjUtil.isAllNotEmpty((Object[])new Object[]{queryVO.getStartDt(), queryVO.getEndDt()}), (Object)"batch.create_dt", (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).eq((Object)"batch.deleted", (Object)0)).orderByDesc((Object)"batch.id");
        List batchResponseDOList = this.jobTaskBatchMapper.selectJobBatchPageList((IPage)pageDTO, (Wrapper)wrapper);
        List<JobBatchResponseWebVO> batchResponseVOList = JobBatchResponseVOConverter.INSTANCE.convertList(batchResponseDOList);
        return new PageResult<List<JobBatchResponseWebVO>>(pageDTO, batchResponseVOList);
    }

    @Override
    public boolean stop(Long taskBatchId) {
        return this.jobHandler.stop(taskBatchId);
    }

    @Override
    @Transactional
    public Boolean retry(Long taskBatchId) {
        return this.jobHandler.retry(taskBatchId);
    }

    @Override
    public Boolean deleteJobBatchByIds(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        this.jobHandler.deleteJobTaskBatchByIds(ids, namespaceId);
        return Boolean.TRUE;
    }

    @Generated
    public JobWebBatchServiceImpl(JobTaskBatchMapper jobTaskBatchMapper, JobHandler jobHandler) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobHandler = jobHandler;
    }
}

