/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.JobPrepareHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.cache.ResidentTaskCache;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportJobVO;
import com.aizuda.snailjob.server.web.model.request.JobQueryVO;
import com.aizuda.snailjob.server.web.model.request.JobRequestVO;
import com.aizuda.snailjob.server.web.model.request.JobStatusUpdateRequestVO;
import com.aizuda.snailjob.server.web.model.request.JobTriggerVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.JobResponseVO;
import com.aizuda.snailjob.server.web.service.JobService;
import com.aizuda.snailjob.server.web.service.convert.JobConverter;
import com.aizuda.snailjob.server.web.service.convert.JobResponseVOConverter;
import com.aizuda.snailjob.server.web.service.handler.GroupHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SystemUserMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobSummary;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class JobServiceImpl
implements JobService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);
    private final SystemProperties systemProperties;
    private final JobMapper jobMapper;
    private final JobPrepareHandler terminalJobPrepareHandler;
    private final AccessTemplate accessTemplate;
    private final GroupHandler groupHandler;
    private final JobSummaryMapper jobSummaryMapper;
    private final SystemUserMapper systemUserMapper;

    private static Long calculateNextTriggerAt(JobRequestVO jobRequestVO, Long time) {
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return 0L;
        }
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)jobRequestVO.getTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(jobRequestVO.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    @Override
    public PageResult<List<JobResponseVO>> getJobPage(JobQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        PageDTO selectPage = (PageDTO)this.jobMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)userSessionVO.getNamespaceId())).in(CollUtil.isNotEmpty(groupNames), Job::getGroupName, groupNames)).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getJobName()), Job::getJobName, (Object)StrUtil.trim((CharSequence)queryVO.getJobName()))).like(StrUtil.isNotBlank((CharSequence)queryVO.getExecutorInfo()), Job::getExecutorInfo, (Object)StrUtil.trim((CharSequence)queryVO.getExecutorInfo()))).eq(Objects.nonNull(queryVO.getJobStatus()), Job::getJobStatus, (Object)queryVO.getJobStatus())).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(Objects.nonNull(queryVO.getOwnerId()), Job::getOwnerId, (Object)queryVO.getOwnerId())).orderByDesc(Job::getId));
        List<JobResponseVO> jobResponseList = JobResponseVOConverter.INSTANCE.convertList(selectPage.getRecords());
        for (JobResponseVO jobResponseVO : jobResponseList) {
            SystemUser systemUser = (SystemUser)this.systemUserMapper.selectById((Serializable)jobResponseVO.getOwnerId());
            if (!Objects.nonNull(systemUser)) continue;
            jobResponseVO.setOwnerName(systemUser.getUsername());
        }
        return new PageResult<List<JobResponseVO>>(pageDTO, jobResponseList);
    }

    @Override
    public JobResponseVO getJobDetail(Long id) {
        Job job = (Job)this.jobMapper.selectById((Serializable)id);
        return JobResponseVOConverter.INSTANCE.convert(job);
    }

    @Override
    public List<String> getTimeByCron(String cron) {
        return CronUtils.getExecuteTimeByCron((String)cron, (int)5);
    }

    @Override
    public List<JobResponseVO> getJobNameList(String keywords, Long jobId, String groupName) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        PageDTO selectPage = (PageDTO)this.jobMapper.selectPage((IPage)new PageDTO(1L, 100L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Job::getId, Job::getJobName}).eq(Job::getNamespaceId, (Object)userSessionVO.getNamespaceId())).likeRight(StrUtil.isNotBlank((CharSequence)keywords), Job::getJobName, (Object)StrUtil.trim((CharSequence)keywords))).eq(StrUtil.isNotBlank((CharSequence)groupName), Job::getGroupName, (Object)groupName)).eq(Objects.nonNull(jobId), Job::getId, (Object)jobId)).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(Job::getId));
        return JobResponseVOConverter.INSTANCE.convertList(selectPage.getRecords());
    }

    @Override
    public boolean saveJob(JobRequestVO jobRequestVO) {
        Job job = JobConverter.INSTANCE.convert(jobRequestVO);
        job.setResident(this.isResident(jobRequestVO));
        job.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(jobRequestVO.getGroupName() + jobRequestVO.getJobName())) % this.systemProperties.getBucketTotal()));
        job.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, DateUtils.toNowMilli()));
        job.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        job.setNotifyIds(JsonUtil.toJsonString(jobRequestVO.getNotifyIds()));
        job.setOwnerId(jobRequestVO.getOwnerId());
        job.setId(null);
        return 1 == this.jobMapper.insert((Object)job);
    }

    @Override
    public boolean updateJob(JobRequestVO jobRequestVO) {
        Assert.notNull((Object)jobRequestVO.getId(), () -> new SnailJobServerException("id \u4e0d\u80fd\u4e3a\u7a7a"));
        Job job = (Job)this.jobMapper.selectById((Serializable)jobRequestVO.getId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("\u66f4\u65b0\u5931\u8d25"));
        Job updateJob = JobConverter.INSTANCE.convert(jobRequestVO);
        updateJob.setNotifyIds(JsonUtil.toJsonString(jobRequestVO.getNotifyIds()));
        updateJob.setOwnerId(jobRequestVO.getOwnerId());
        updateJob.setResident(this.isResident(jobRequestVO));
        updateJob.setNamespaceId(job.getNamespaceId());
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            job.setNextTriggerAt(Long.valueOf(0L));
        } else if (Objects.equals(job.getResident(), StatusEnum.NO.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.NO.getStatus())) {
            updateJob.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, DateUtils.toNowMilli()));
        } else if (Objects.equals(job.getResident(), StatusEnum.YES.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.NO.getStatus())) {
            long time = Optional.ofNullable(ResidentTaskCache.get((Long)jobRequestVO.getId())).orElse(DateUtils.toNowMilli());
            updateJob.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, time));
        } else if (Objects.equals(job.getResident(), StatusEnum.NO.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.YES.getStatus())) {
            updateJob.setNextTriggerAt(Long.valueOf(DateUtils.toNowMilli()));
        }
        updateJob.setGroupName(null);
        return 1 == this.jobMapper.updateById((Object)updateJob);
    }

    private Integer isResident(JobRequestVO jobRequestVO) {
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return StatusEnum.NO.getStatus();
        }
        if (jobRequestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.FIXED.getType()) {
            if (Integer.parseInt(jobRequestVO.getTriggerInterval()) < 10) {
                return StatusEnum.YES.getStatus();
            }
        } else if (jobRequestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType()) {
            if (CronUtils.getExecuteInterval((String)jobRequestVO.getTriggerInterval()) < 10000L) {
                return StatusEnum.YES.getStatus();
            }
        } else {
            throw new SnailJobServerException("\u672a\u77e5\u89e6\u53d1\u7c7b\u578b");
        }
        return StatusEnum.NO.getStatus();
    }

    @Override
    public Boolean updateJobStatus(JobStatusUpdateRequestVO jobRequestVO) {
        Assert.notNull((Object)jobRequestVO.getId(), () -> new SnailJobServerException("id \u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((1L == this.jobMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Job::getId, (Object)jobRequestVO.getId())) ? 1 : 0) != 0);
        Job job = new Job();
        job.setId(jobRequestVO.getId());
        job.setJobStatus(jobRequestVO.getJobStatus());
        return 1 == this.jobMapper.updateById((Object)job);
    }

    @Override
    public boolean trigger(JobTriggerVO jobTrigger) {
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTrigger.getJobId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("job can not be null."));
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)job.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)job.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{job.getGroupName()}));
        JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(job);
        jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli());
        jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_JOB.getType());
        if (StrUtil.isNotBlank((CharSequence)jobTrigger.getTmpArgsStr())) {
            jobTaskPrepare.setTmpArgsStr(jobTrigger.getTmpArgsStr());
        }
        this.terminalJobPrepareHandler.handle(jobTaskPrepare);
        return Boolean.TRUE;
    }

    @Override
    public List<JobResponseVO> getJobList(String groupName) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List jobs = this.jobMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Job::getId, Job::getJobName}).eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getGroupName, (Object)groupName)).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(CreateDt::getCreateDt));
        List<JobResponseVO> jobResponseList = JobResponseVOConverter.INSTANCE.convertList(jobs);
        return jobResponseList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importJobs(List<JobRequestVO> requestList) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        this.groupHandler.validateGroupExistence(StreamUtils.toSet(requestList, JobRequestVO::getGroupName), namespaceId);
        requestList.forEach(this::saveJob);
    }

    @Override
    public String exportJobs(ExportJobVO exportJobVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ArrayList requestList = new ArrayList();
        PartitionTaskUtils.process(startId -> {
            List jobList = ((PageDTO)this.jobMapper.selectPage((IPage)new PageDTO(0L, 100L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)namespaceId)).eq(StrUtil.isNotBlank((CharSequence)exportJobVO.getGroupName()), Job::getGroupName, (Object)exportJobVO.getGroupName())).likeRight(StrUtil.isNotBlank((CharSequence)exportJobVO.getJobName()), Job::getJobName, (Object)StrUtil.trim((CharSequence)exportJobVO.getJobName()))).eq(Objects.nonNull(exportJobVO.getJobStatus()), Job::getJobStatus, (Object)exportJobVO.getJobStatus())).in(CollUtil.isNotEmpty(exportJobVO.getJobIds()), Job::getId, exportJobVO.getJobIds())).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).gt(Job::getId, (Object)startId)).orderByAsc(Job::getId))).getRecords();
            return StreamUtils.toList((Collection)jobList, JobPartitionTask::new);
        }, partitionTasks -> {
            List jobPartitionTasks = partitionTasks;
            requestList.addAll(JobConverter.INSTANCE.convertList(StreamUtils.toList((Collection)jobPartitionTasks, JobPartitionTask::getJob)));
        }, (long)0L);
        return JsonUtil.toJsonString(requestList);
    }

    @Override
    @Transactional
    public Boolean deleteJobByIds(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Assert.isTrue((ids.size() == this.jobMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getJobStatus, (Object)StatusEnum.NO.getStatus())).in(Job::getId, ids)) ? 1 : 0) != 0, () -> new SnailJobServerException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25, \u8bf7\u68c0\u67e5\u4efb\u52a1\u72b6\u6001\u662f\u5426\u5173\u95ed\u72b6\u6001"));
        List jobSummaries = this.jobSummaryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobSummary::getId}).in(JobSummary::getBusinessId, ids)).eq(JobSummary::getNamespaceId, (Object)namespaceId)).eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.JOB.getType()));
        if (CollUtil.isNotEmpty((Collection)jobSummaries)) {
            this.jobSummaryMapper.deleteByIds((Collection)StreamUtils.toSet((Collection)jobSummaries, JobSummary::getId));
        }
        return Boolean.TRUE;
    }

    @Generated
    public JobServiceImpl(SystemProperties systemProperties, JobMapper jobMapper, JobPrepareHandler terminalJobPrepareHandler, AccessTemplate accessTemplate, GroupHandler groupHandler, JobSummaryMapper jobSummaryMapper, SystemUserMapper systemUserMapper) {
        this.systemProperties = systemProperties;
        this.jobMapper = jobMapper;
        this.terminalJobPrepareHandler = terminalJobPrepareHandler;
        this.accessTemplate = accessTemplate;
        this.groupHandler = groupHandler;
        this.jobSummaryMapper = jobSummaryMapper;
        this.systemUserMapper = systemUserMapper;
    }

    private static class JobPartitionTask
    extends PartitionTask {
        private final Job job;

        public JobPartitionTask(@NotNull Job job) {
            this.job = job;
            this.setId(job.getId());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobPartitionTask)) {
                return false;
            }
            JobPartitionTask other = (JobPartitionTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Job this$job = this.getJob();
            Job other$job = other.getJob();
            return !(this$job == null ? other$job != null : !this$job.equals(other$job));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JobPartitionTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Job $job = this.getJob();
            result = result * 59 + ($job == null ? 43 : $job.hashCode());
            return result;
        }

        @Generated
        public Job getJob() {
            return this.job;
        }
    }
}

