/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.handler;

import akka.actor.ActorRef;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.client.model.ExecuteResult;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.TaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.enums.JobRetrySceneEnum;
import com.aizuda.snailjob.server.job.task.support.ClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.JobTaskStopHandler;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackFactory;
import com.aizuda.snailjob.server.job.task.support.stop.JobTaskStopFactory;
import com.aizuda.snailjob.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimeoutCheckTask;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimerWheel;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobLogMessage;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class JobHandler {
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobMapper jobMapper;
    private final JobTaskMapper jobTaskMapper;
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final JobLogMessageMapper jobLogMessageMapper;

    public Boolean retry(Long taskBatchId) {
        return this.retry(taskBatchId, null, null);
    }

    public Boolean retry(Long taskBatchId, Long workflowNodeId, Long workflowTaskBatchId) {
        JobTaskBatch jobTaskBatch = (JobTaskBatch)this.jobTaskBatchMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getId, (Object)taskBatchId)).in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_SUCCESS));
        Assert.notNull((Object)jobTaskBatch, () -> new SnailJobServerException("job batch can not be null."));
        jobTaskBatch.setTaskBatchStatus(Integer.valueOf(JobTaskBatchStatusEnum.RUNNING.getStatus()));
        jobTaskBatch.setOperationReason(Integer.valueOf(JobOperationReasonEnum.NONE.getReason()));
        Assert.isTrue((this.jobTaskBatchMapper.updateById((Object)jobTaskBatch) > 0 ? 1 : 0) != 0, () -> new SnailJobServerException("update job batch to running failed."));
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTaskBatch.getJobId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("job can not be null."));
        List jobTasks = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTask::getId, JobTask::getTaskStatus}).eq(JobTask::getTaskBatchId, (Object)taskBatchId));
        if (CollUtil.isEmpty((Collection)jobTasks)) {
            TaskExecuteDTO taskExecuteDTO = new TaskExecuteDTO();
            taskExecuteDTO.setTaskBatchId(taskBatchId);
            taskExecuteDTO.setJobId(jobTaskBatch.getJobId());
            taskExecuteDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_JOB.getType());
            taskExecuteDTO.setWorkflowTaskBatchId(workflowTaskBatchId);
            taskExecuteDTO.setWorkflowNodeId(workflowNodeId);
            ActorRef actorRef = ActorGenerator.jobTaskExecutorActor();
            actorRef.tell((Object)taskExecuteDTO, actorRef);
            return Boolean.TRUE;
        }
        String wfContext = this.getWfContext(workflowTaskBatchId);
        for (JobTask jobTask : jobTasks) {
            if (jobTask.getTaskStatus().intValue() == JobTaskStatusEnum.RUNNING.getStatus() || jobTask.getTaskStatus().intValue() == JobTaskStatusEnum.SUCCESS.getStatus()) continue;
            jobTask.setTaskStatus(Integer.valueOf(JobTaskStatusEnum.RUNNING.getStatus()));
            Assert.isTrue((this.jobTaskMapper.updateById((Object)jobTask) > 0 ? 1 : 0) != 0, () -> new SnailJobServerException("update job task to running failed."));
            ClientCallbackHandler clientCallback = ClientCallbackFactory.getClientCallback((Integer)job.getTaskType());
            ClientCallbackContext context = JobTaskConverter.INSTANCE.toClientCallbackContext(job);
            context.setTaskBatchId(jobTaskBatch.getId());
            context.setWorkflowNodeId(workflowNodeId);
            context.setWorkflowTaskBatchId(workflowTaskBatchId);
            context.setTaskId(jobTask.getId());
            context.setTaskStatus(Integer.valueOf(JobTaskStatusEnum.FAIL.getStatus()));
            context.setRetryScene(JobRetrySceneEnum.MANUAL.getRetryScene());
            context.setWfContext(wfContext);
            context.setExecuteResult(ExecuteResult.failure(null, (String)"\u624b\u52a8\u91cd\u8bd5"));
            clientCallback.callback(context);
        }
        JobTimerWheel.registerWithJob(() -> new JobTimeoutCheckTask(taskBatchId, job.getId()), (Duration)Duration.ofMillis(DateUtils.toEpochMilli((long)job.getExecutorTimeout().intValue()) + 500L));
        return Boolean.TRUE;
    }

    public Boolean stop(Long taskBatchId) {
        JobTaskBatch jobTaskBatch = (JobTaskBatch)this.jobTaskBatchMapper.selectById((Serializable)taskBatchId);
        Assert.notNull((Object)jobTaskBatch, () -> new SnailJobServerException("job batch can not be null."));
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTaskBatch.getJobId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("job can not be null."));
        JobTaskStopHandler jobTaskStop = JobTaskStopFactory.getJobTaskStop((Integer)job.getTaskType());
        TaskStopJobContext taskStopJobContext = JobTaskConverter.INSTANCE.toStopJobContext(job);
        taskStopJobContext.setJobOperationReason(Integer.valueOf(JobOperationReasonEnum.MANNER_STOP.getReason()));
        taskStopJobContext.setTaskBatchId(jobTaskBatch.getId());
        taskStopJobContext.setForceStop(Boolean.TRUE.booleanValue());
        taskStopJobContext.setNeedUpdateTaskStatus(Boolean.TRUE.booleanValue());
        jobTaskStop.stop(taskStopJobContext);
        return Boolean.TRUE;
    }

    private String getWfContext(Long workflowTaskBatchId) {
        if (Objects.isNull(workflowTaskBatchId)) {
            return null;
        }
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{WorkflowTaskBatch::getWfContext}).eq(WorkflowTaskBatch::getId, (Object)workflowTaskBatchId));
        if (Objects.isNull(workflowTaskBatch)) {
            return null;
        }
        return workflowTaskBatch.getWfContext();
    }

    @Transactional
    public void deleteJobTaskBatchByIds(Set<Long> ids, String namespaceId) {
        Assert.isTrue((ids.size() == this.jobTaskBatchMapper.deleteByIds(ids) ? 1 : 0) != 0, () -> new SnailJobServerException("\u5220\u9664\u4efb\u52a1\u6279\u6b21\u5931\u8d25"));
        this.jobTaskMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTask::getNamespaceId, (Object)namespaceId)).in(JobTask::getTaskBatchId, ids));
        this.jobLogMessageMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobLogMessage::getNamespaceId, (Object)namespaceId)).in(JobLogMessage::getTaskBatchId, ids));
    }

    public JobHandler(JobTaskBatchMapper jobTaskBatchMapper, JobMapper jobMapper, JobTaskMapper jobTaskMapper, WorkflowTaskBatchMapper workflowTaskBatchMapper, JobLogMessageMapper jobLogMessageMapper) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobMapper = jobMapper;
        this.jobTaskMapper = jobTaskMapper;
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.jobLogMessageMapper = jobLogMessageMapper;
    }
}

