/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.JobBatchQueryVO;
import com.aizuda.snailjob.server.web.model.response.JobBatchResponseVO;
import com.aizuda.snailjob.server.web.service.JobBatchService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Set;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/job/batch"})
public class JobBatchController {
    private final JobBatchService jobBatchService;

    @GetMapping(value={"/list"})
    @LoginRequired
    public PageResult<List<JobBatchResponseVO>> getJobBatchPage(JobBatchQueryVO jobQueryVO) {
        return this.jobBatchService.getJobBatchPage(jobQueryVO);
    }

    @GetMapping(value={"{id}"})
    @LoginRequired
    public JobBatchResponseVO getJobBatchDetail(@PathVariable(value="id") Long id) {
        return this.jobBatchService.getJobBatchDetail(id);
    }

    @PostMapping(value={"/stop/{taskBatchId}"})
    @LoginRequired
    public Boolean stop(@PathVariable(value="taskBatchId") Long taskBatchId) {
        return this.jobBatchService.stop(taskBatchId);
    }

    @PostMapping(value={"/retry/{taskBatchId}"})
    @LoginRequired
    public Boolean retry(@PathVariable(value="taskBatchId") Long taskBatchId) {
        return this.jobBatchService.retry(taskBatchId);
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired
    public Boolean deleteJobBatchByIds(@RequestBody @Valid @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=100, message="\u6700\u591a\u5220\u96645\u4e2a") @Valid @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=100, message="\u6700\u591a\u5220\u96645\u4e2a") Set<Long> ids) {
        return this.jobBatchService.deleteJobBatchByIds(ids);
    }

    public JobBatchController(JobBatchService jobBatchService) {
        this.jobBatchService = jobBatchService;
    }
}

