/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.starter.schedule;

import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OfflineNodeSchedule
extends AbstractSchedule
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(OfflineNodeSchedule.class);
    private final ServerNodeMapper serverNodeMapper;

    protected void doExecute() {
        try {
            LocalDateTime endTime = LocalDateTime.now().minusSeconds(40L);
            this.serverNodeMapper.delete((Wrapper)new LambdaQueryWrapper().le(ServerNode::getExpireAt, (Object)endTime));
            Set allPods = CacheRegisterTable.getAllPods();
            Set waitOffline = allPods.stream().filter(registerNodeInfo -> registerNodeInfo.getExpireAt().isBefore(endTime)).collect(Collectors.toSet());
            Set podIds = StreamUtils.toSet(waitOffline, RegisterNodeInfo::getHostId);
            if (CollectionUtils.isEmpty((Collection)podIds)) {
                return;
            }
            for (RegisterNodeInfo registerNodeInfo2 : waitOffline) {
                CacheRegisterTable.remove((String)registerNodeInfo2.getGroupName(), (String)registerNodeInfo2.getNamespaceId(), (String)registerNodeInfo2.getHostId());
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("clearOfflineNode \u5931\u8d25", new Object[]{e});
        }
    }

    public String lockName() {
        return "clearOfflineNode";
    }

    public String lockAtMost() {
        return "PT10S";
    }

    public String lockAtLeast() {
        return "PT5S";
    }

    public void start() {
        this.taskScheduler.scheduleWithFixedDelay(() -> ((OfflineNodeSchedule)this).execute(), Instant.now(), Duration.parse("PT5S"));
    }

    public void close() {
    }

    public OfflineNodeSchedule(ServerNodeMapper serverNodeMapper) {
        this.serverNodeMapper = serverNodeMapper;
    }
}

