/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.starter.dispatch;

import akka.actor.ActorRef;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.dto.DistributeInstance;
import com.aizuda.snailjob.server.starter.dispatch.ConsumerBucket;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DispatchService
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(DispatchService.class);
    private final ScheduledExecutorService dispatchService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "dispatch-service"));
    public static final Long PERIOD = SystemConstants.SCHEDULE_PERIOD;
    public static final Long INITIAL_DELAY = SystemConstants.SCHEDULE_INITIAL_DELAY;

    public void start() {
        ActorRef actorRef = ActorGenerator.scanBucketActor();
        this.dispatchService.scheduleAtFixedRate(() -> {
            try {
                Set<Integer> currentConsumerBuckets;
                if (DistributeInstance.RE_BALANCE_ING.get()) {
                    SnailJobLog.LOCAL.info("\u6b63\u5728rebalance\u4e2d....", new Object[0]);
                    TimeUnit.SECONDS.sleep(INITIAL_DELAY);
                }
                if (!CollectionUtils.isEmpty(currentConsumerBuckets = this.getConsumerBucket())) {
                    ConsumerBucket scanTaskDTO = new ConsumerBucket();
                    scanTaskDTO.setBuckets(currentConsumerBuckets);
                    actorRef.tell((Object)scanTaskDTO, actorRef);
                }
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u5206\u53d1\u5f02\u5e38", new Object[]{e});
            }
        }, INITIAL_DELAY, PERIOD, TimeUnit.SECONDS);
    }

    private Set<Integer> getConsumerBucket() {
        return DistributeInstance.INSTANCE.getConsumerBucket();
    }

    public void close() {
    }
}

