/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.timer;

import akka.actor.ActorRef;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskExecuteDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.timer.AbstractTimerTask;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerContext;
import io.netty.util.Timeout;
import java.text.MessageFormat;

public class RetryTimerTask
extends AbstractTimerTask {
    public static final String IDEMPOTENT_KEY_PREFIX = "retry_task_{0}";
    private final RetryTimerContext context;

    @Override
    public void doRun(Timeout timeout) {
        RetryTaskExecuteDTO taskExecuteDTO = RetryTaskConverter.INSTANCE.toRetryTaskExecuteDTO(this.context);
        ActorRef actorRef = ActorGenerator.retryTaskExecutorActor();
        actorRef.tell((Object)taskExecuteDTO, actorRef);
    }

    public RetryTimerTask(RetryTimerContext context) {
        this.context = context;
        this.retryId = context.getRetryId();
        this.retryTaskId = context.getRetryTaskId();
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.context.getRetryTaskId());
    }
}

