/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import akka.actor.AbstractActor;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.retry.task.dto.RetryExecutorResultDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryResultHandler;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.result.RetryResultContext;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RetryExecutorResultActor")
@Scope(value="prototype")
public class RetryResultActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryResultActor.class);
    private final List<RetryResultHandler> retryResultHandlers;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryExecutorResultDTO.class, result -> {
            try {
                this.doResult((RetryExecutorResultDTO)result);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("Result processing exception. [{}]", new Object[]{result, e});
            }
        }).build();
    }

    private void doResult(RetryExecutorResultDTO result) {
        RetryResultContext context = RetryTaskConverter.INSTANCE.toRetryResultContext(result);
        for (RetryResultHandler retryResultHandler : this.retryResultHandlers) {
            if (!retryResultHandler.supports(context)) continue;
            retryResultHandler.handle(context);
        }
    }

    @Generated
    public RetryResultActor(List<RetryResultHandler> retryResultHandlers) {
        this.retryResultHandlers = retryResultHandlers;
    }
}

