/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import com.aizuda.snailjob.client.model.request.DispatchRetryRequest;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.model.SnailJobHeaders;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.rpc.client.SnailJobRetryListener;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.dto.RequestRetryExecutorDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryExecutorResultDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskLogConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.google.common.collect.Maps;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RealRetryExecutorActor")
@Scope(value="prototype")
public class RequestRetryClientActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestRetryClientActor.class);
    private final RetryTaskMapper retryTaskMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RequestRetryExecutorDTO.class, realRetryExecutorDTO -> {
            try {
                this.doExecute((RequestRetryExecutorDTO)realRetryExecutorDTO);
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u5ba2\u6237\u7aef\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }).build();
    }

    private void doExecute(RequestRetryExecutorDTO executorDTO) {
        long nowMilli = DateUtils.toNowMilli();
        RegisterNodeInfo registerNodeInfo = CacheRegisterTable.getServerNode((String)executorDTO.getGroupName(), (String)executorDTO.getNamespaceId(), (String)executorDTO.getClientId());
        if (Objects.isNull(registerNodeInfo)) {
            RequestRetryClientActor.taskExecuteFailure(executorDTO, "\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728");
            JobLogMetaDTO jobLogMetaDTO = RetryTaskConverter.INSTANCE.toJobLogDTO(executorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("retryTaskId:[{}] \u4efb\u52a1\u8c03\u5ea6\u5931\u8d25. \u5931\u8d25\u539f\u56e0: \u65e0\u53ef\u6267\u884c\u7684\u5ba2\u6237\u7aef <|>{}<|>", new Object[]{executorDTO.getRetryTaskId(), jobLogMetaDTO});
            return;
        }
        DispatchRetryRequest dispatchJobRequest = RetryTaskConverter.INSTANCE.toDispatchRetryRequest(executorDTO);
        try {
            SnailJobHeaders snailJobHeaders = new SnailJobHeaders();
            snailJobHeaders.setRetry(Boolean.TRUE.booleanValue());
            snailJobHeaders.setRetryId(String.valueOf(executorDTO.getRetryId()));
            snailJobHeaders.setDdl((long)executorDTO.getExecutorTimeout().intValue());
            RetryRpcClient rpcClient = this.buildRpcClient(registerNodeInfo, executorDTO);
            Result<Boolean> dispatch = rpcClient.dispatch(dispatchJobRequest, snailJobHeaders);
            Boolean data = (Boolean)dispatch.getData();
            if (dispatch.getStatus() == StatusEnum.YES.getStatus().intValue() && Objects.nonNull(data) && data.booleanValue()) {
                SnailJobLog.LOCAL.info("retryTaskId:[{}] \u4efb\u52a1\u8c03\u5ea6\u6210\u529f.", new Object[]{executorDTO.getRetryTaskId()});
            } else {
                SnailJobLog.LOCAL.error("retryTaskId:[{}] \u4efb\u52a1\u8c03\u5ea6\u5931\u8d25. msg:[{}]", new Object[]{executorDTO.getRetryTaskId(), dispatch.getMessage()});
                RequestRetryClientActor.taskExecuteFailure(executorDTO, dispatch.getMessage());
            }
        }
        catch (Exception e) {
            Throwable throwable;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                re = (RetryException)e;
                throwable = re.getLastFailedAttempt().getExceptionCause();
            } else if (e.getClass().isAssignableFrom(UndeclaredThrowableException.class)) {
                re = (UndeclaredThrowableException)e;
                throwable = ((UndeclaredThrowableException)re).getUndeclaredThrowable();
            } else {
                throwable = e;
            }
            RetryLogMetaDTO retryTaskLogDTO = RetryTaskLogConverter.INSTANCE.toRetryLogMetaDTO(executorDTO);
            retryTaskLogDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("retryTaskId:[{}] \u4efb\u52a1\u8c03\u5ea6\u5931\u8d25. <|>{}<|>", new Object[]{retryTaskLogDTO.getRetryTaskId(), retryTaskLogDTO, throwable});
            RequestRetryClientActor.taskExecuteFailure(executorDTO, throwable.getMessage());
        }
    }

    private RetryRpcClient buildRpcClient(RegisterNodeInfo registerNodeInfo, RequestRetryExecutorDTO executorDTO) {
        return (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(registerNodeInfo).failRetry(true).failover(true).retryTimes(3).retryInterval(1).routeKey(executorDTO.getRouteKey().intValue()).allocKey(String.valueOf(executorDTO.getRetryTaskId())).retryListener((RetryListener)new RetryExecutorRetryListener(executorDTO)).client(RetryRpcClient.class).build();
    }

    private static void taskExecuteFailure(RequestRetryExecutorDTO executorDTO, String message) {
        ActorRef actorRef = ActorGenerator.retryTaskExecutorResultActor();
        RetryExecutorResultDTO executorResultDTO = RetryTaskConverter.INSTANCE.toRetryExecutorResultDTO(executorDTO);
        executorResultDTO.setExceptionMsg(message);
        executorResultDTO.setTaskStatus(RetryTaskStatusEnum.FAIL.getStatus());
        actorRef.tell((Object)executorResultDTO, actorRef);
    }

    @Generated
    public RequestRetryClientActor(RetryTaskMapper retryTaskMapper) {
        this.retryTaskMapper = retryTaskMapper;
    }

    public class RetryExecutorRetryListener
    implements SnailJobRetryListener {
        private final Map<String, Object> properties;
        private final RequestRetryExecutorDTO executorDTO;

        public RetryExecutorRetryListener(RequestRetryExecutorDTO realJobExecutorDTO) {
            this.executorDTO = realJobExecutorDTO;
            this.properties = Maps.newHashMap();
        }

        public <V> void onRetry(Attempt<V> attempt) {
            if (attempt.getAttemptNumber() > 1L) {
                String hostId = (String)this.properties.get("HOST_ID");
                String hostIp = (String)this.properties.get("HOST_IP");
                Integer hostPort = (Integer)this.properties.get("HOST_PORT");
                RetryTask retryTask = new RetryTask();
                retryTask.setId(this.executorDTO.getRetryTaskId());
                RegisterNodeInfo realNodeInfo = new RegisterNodeInfo();
                realNodeInfo.setHostIp(hostIp);
                realNodeInfo.setHostPort(Integer.valueOf(hostPort));
                realNodeInfo.setHostId(hostId);
                retryTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)realNodeInfo));
                RequestRetryClientActor.this.retryTaskMapper.updateById((Object)retryTask);
            }
        }

        public Map<String, Object> properties() {
            return this.properties;
        }
    }
}

