/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.actor.exec;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.client.model.RetryCallbackDTO;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.context.CallbackRetryContext;
import com.aizuda.snailjob.server.retry.task.support.handler.CallbackRetryTaskHandler;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryExecutor;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="ExecCallbackUnitActor")
@Scope(value="prototype")
public class ExecCallbackUnitActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecCallbackUnitActor.class);
    @Autowired
    private AccessTemplate accessTemplate;
    @Autowired
    private CallbackRetryTaskHandler callbackRetryTaskHandler;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryExecutor.class, retryExecutor -> {
            CallbackRetryContext context = (CallbackRetryContext)retryExecutor.getRetryContext();
            RetryTask retryTask = context.getRetryTask();
            RegisterNodeInfo serverNode = context.getServerNode();
            RetrySceneConfig retrySceneConfig = context.getRetrySceneConfig();
            try {
                if (Objects.nonNull(serverNode)) {
                    retryExecutor.call(() -> {
                        Result result = this.callClient(retryTask, serverNode, retrySceneConfig);
                        return result;
                    });
                }
            }
            catch (Exception e) {
                RetryLogMetaDTO retryLogMetaDTO = RetryTaskConverter.INSTANCE.toLogMetaDTO(retryTask);
                retryLogMetaDTO.setTimestamp(Long.valueOf(DateUtils.toNowMilli()));
                SnailJobLog.REMOTE.error("\u8bf7\u6c42\u5ba2\u6237\u7aef\u5f02\u5e38. <|>{}<|>", new Object[]{retryTask.getUniqueId(), retryLogMetaDTO, e});
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private Result callClient(RetryTask callbackTask, RegisterNodeInfo serverNode, RetrySceneConfig retrySceneConfig) {
        String retryTaskUniqueId = this.callbackRetryTaskHandler.getRetryTaskUniqueId(callbackTask.getUniqueId());
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        RetryTask retryTask = (RetryTask)retryTaskAccess.one(callbackTask.getGroupName(), callbackTask.getNamespaceId(), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{RetryTask::getRetryStatus}).eq(RetryTask::getNamespaceId, (Object)serverNode.getNamespaceId())).eq(RetryTask::getGroupName, (Object)callbackTask.getGroupName())).eq(RetryTask::getUniqueId, (Object)retryTaskUniqueId));
        Assert.notNull((Object)retryTask, () -> new SnailJobServerException("\u672a\u67e5\u8be2\u56de\u8c03\u4efb\u52a1\u5bf9\u5e94\u7684\u91cd\u8bd5\u4efb\u52a1. callbackUniqueId:[{}] uniqueId:[{}]", new Object[]{callbackTask.getUniqueId(), retryTaskUniqueId}));
        RetryCallbackDTO retryCallbackDTO = new RetryCallbackDTO();
        retryCallbackDTO.setIdempotentId(callbackTask.getIdempotentId());
        retryCallbackDTO.setRetryStatus(retryTask.getRetryStatus());
        retryCallbackDTO.setArgsStr(callbackTask.getArgsStr());
        retryCallbackDTO.setScene(callbackTask.getSceneName());
        retryCallbackDTO.setGroup(callbackTask.getGroupName());
        retryCallbackDTO.setExecutorName(callbackTask.getExecutorName());
        retryCallbackDTO.setUniqueId(callbackTask.getUniqueId());
        retryCallbackDTO.setNamespaceId(callbackTask.getNamespaceId());
        RetryRpcClient rpcClient = (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(serverNode).failover(Boolean.TRUE.booleanValue()).routeKey(retrySceneConfig.getRouteKey().intValue()).allocKey(retrySceneConfig.getSceneName()).executorTimeout(retrySceneConfig.getExecutorTimeout()).client(RetryRpcClient.class).build();
        return rpcClient.callback(retryCallbackDTO);
    }
}

