/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.convert.JobBatchResponseVOConverter;
import com.aizuda.snailjob.server.common.convert.WorkflowConverter;
import com.aizuda.snailjob.server.common.dto.JobTaskConfig;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.handler.WorkflowHandler;
import com.aizuda.snailjob.server.common.vo.JobBatchResponseVO;
import com.aizuda.snailjob.server.common.vo.WorkflowDetailResponseVO;
import com.aizuda.snailjob.server.job.task.support.cache.MutableGraphCache;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiGetWorkflowBatchDetailRequestHandler
extends PostHttpRequestHandler {
    private static final Integer WORKFLOW_DECISION_FAILED_STATUS = 98;
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final WorkflowMapper workflowMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final WorkflowHandler workflowHandler;
    private final JobMapper jobMapper;

    public boolean supports(String path) {
        return "/api/job/getWorkflowBatchDetail".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("query workflow batch content:[{}]", new Object[]{content});
        SnailJobRequest jobRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = jobRequest.getArgs();
        Long workflowBatchId = (Long)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), Long.class);
        Assert.notNull((Object)workflowBatchId, () -> new SnailJobServerException("id cannot be null"));
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(WorkflowTaskBatch::getId, (Object)workflowBatchId));
        if (Objects.isNull(workflowTaskBatch)) {
            return new SnailJobRpcResult(null, jobRequest.getReqId());
        }
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)workflowTaskBatch.getWorkflowId());
        WorkflowDetailResponseVO responseVO = WorkflowConverter.INSTANCE.convert(workflow);
        responseVO.setWorkflowBatchStatus(workflowTaskBatch.getTaskBatchStatus());
        List workflowNodes = this.workflowNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowNode::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(WorkflowNode::getWorkflowId, (Object)workflow.getId()));
        List jobs = this.jobMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Job::getId, (Collection)StreamUtils.toSet((Collection)workflowNodes, WorkflowNode::getJobId)));
        Map jobMap = StreamUtils.toIdentityMap((Collection)jobs, Job::getId);
        List alJobTaskBatchList = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowBatchId)).orderByDesc(JobTaskBatch::getId));
        Map jobTaskBatchMap = StreamUtils.groupByKey((Collection)alJobTaskBatchList, JobTaskBatch::getWorkflowNodeId);
        List nodeInfos = WorkflowConverter.INSTANCE.convertList(workflowNodes);
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph<Long> graph = MutableGraphCache.getOrDefault(workflowBatchId, flowInfo);
        HashSet allNoOperationNode = Sets.newHashSet();
        Map workflowNodeMap = nodeInfos.stream().peek(nodeInfo -> {
            List jobTaskBatchList;
            JobTaskConfig jobTask = nodeInfo.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobTask.setJobName(jobMap.getOrDefault(jobTask.getJobId(), new Job()).getJobName());
            }
            if (CollUtil.isNotEmpty((Collection)(jobTaskBatchList = (List)jobTaskBatchMap.get(nodeInfo.getId())))) {
                jobTaskBatchList = jobTaskBatchList.stream().sorted(Comparator.comparingInt(JobTaskBatch::getTaskBatchStatus)).collect(Collectors.toList());
                nodeInfo.setJobBatchList(JobBatchResponseVOConverter.INSTANCE.convertListToJobBatchList(jobTaskBatchList));
                JobTaskBatch jobTaskBatch = (JobTaskBatch)jobTaskBatchList.get(0);
                if (JobOperationReasonEnum.WORKFLOW_DECISION_FAILED.getReason() == jobTaskBatch.getOperationReason().intValue()) {
                    nodeInfo.setTaskBatchStatus(WORKFLOW_DECISION_FAILED_STATUS);
                } else {
                    nodeInfo.setTaskBatchStatus(jobTaskBatch.getTaskBatchStatus());
                }
                if (jobTaskBatchList.stream().filter(Objects::nonNull).anyMatch(OpenApiGetWorkflowBatchDetailRequestHandler::isNoOperation)) {
                    Set<Long> allDescendants = MutableGraphCache.getAllDescendants(graph, nodeInfo.getId());
                    allNoOperationNode.addAll(allDescendants);
                } else {
                    allNoOperationNode.remove(nodeInfo.getId());
                }
            } else if (JobTaskBatchStatusEnum.NOT_SUCCESS.contains(workflowTaskBatch.getTaskBatchStatus())) {
                allNoOperationNode.add(nodeInfo.getId());
            }
        }).collect(Collectors.toMap(WorkflowDetailResponseVO.NodeInfo::getId, Function.identity()));
        for (Long noOperationNodeId : allNoOperationNode) {
            WorkflowDetailResponseVO.NodeInfo nodeInfo2 = (WorkflowDetailResponseVO.NodeInfo)workflowNodeMap.get(noOperationNodeId);
            List jobTaskBatches = (List)jobTaskBatchMap.get(nodeInfo2.getId());
            if (CollUtil.isNotEmpty((Collection)jobTaskBatches)) {
                jobTaskBatches = jobTaskBatches.stream().sorted(Comparator.comparingInt(JobTaskBatch::getTaskBatchStatus)).collect(Collectors.toList());
                nodeInfo2.setJobBatchList(JobBatchResponseVOConverter.INSTANCE.convertListToJobBatchList(jobTaskBatches));
                continue;
            }
            JobBatchResponseVO jobBatchResponseVO = new JobBatchResponseVO();
            JobTaskConfig jobTask = nodeInfo2.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobBatchResponseVO.setJobId(jobTask.getJobId());
            }
            nodeInfo2.setJobBatchList((List)Lists.newArrayList((Object[])new JobBatchResponseVO[]{jobBatchResponseVO}));
        }
        try {
            WorkflowDetailResponseVO.NodeConfig config = this.workflowHandler.buildNodeConfig(graph, SystemConstants.ROOT, new HashMap(), workflowNodeMap);
            responseVO.setNodeConfig(config);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Deserialization failed. json:[{}]", new Object[]{flowInfo, e});
            throw new SnailJobServerException("Failed to query workflow batch details");
        }
        return new SnailJobRpcResult((Object)responseVO, jobRequest.getReqId());
    }

    private static boolean isNoOperation(JobTaskBatch i) {
        return JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(i.getOperationReason()) || i.getTaskBatchStatus().intValue() == JobTaskBatchStatusEnum.STOP.getStatus();
    }

    @Generated
    public OpenApiGetWorkflowBatchDetailRequestHandler(WorkflowTaskBatchMapper workflowTaskBatchMapper, WorkflowMapper workflowMapper, WorkflowNodeMapper workflowNodeMapper, JobTaskBatchMapper jobTaskBatchMapper, WorkflowHandler workflowHandler, JobMapper jobMapper) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.workflowMapper = workflowMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.workflowHandler = workflowHandler;
        this.jobMapper = jobMapper;
    }
}

