/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.convert.JobResponseVOConverter;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.vo.JobResponseVO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiGetJobDetailRequestHandler
extends PostHttpRequestHandler {
    private final JobMapper jobMapper;

    public boolean supports(String path) {
        return "/api/job/getJobDetail".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Update job content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        Long jobId = (Long)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), Long.class);
        Assert.notNull((Object)jobId, () -> new SnailJobServerException("id cannot be null"));
        Job job = (Job)this.jobMapper.selectById((Serializable)jobId);
        JobResponseVO convert = JobResponseVOConverter.INSTANCE.convert(job);
        return new SnailJobRpcResult((Object)convert, retryRequest.getReqId());
    }

    @Generated
    public OpenApiGetJobDetailRequestHandler(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }
}

