/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.util;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.util.CronExpression;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CronUtils {
    public static List<String> getExecuteTimeByCron(String cron, int nums) {
        ArrayList<String> list = new ArrayList<String>();
        LocalDateTime now = LocalDateTime.now();
        for (int i = 0; i < nums; ++i) {
            try {
                ZonedDateTime zdt = now.atZone(ZoneOffset.ofHours(8));
                Date nextValidTime = new CronExpression(cron).getNextValidTimeAfter(Date.from(zdt.toInstant()));
                if (Objects.isNull(nextValidTime)) continue;
                now = LocalDateTime.ofEpochSecond(nextValidTime.getTime() / 1000L, 0, ZoneOffset.ofHours(8));
                list.add(DateUtils.format(now, DateUtils.NORM_DATETIME_PATTERN));
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return list;
    }

    public static long getExecuteInterval(String cron) {
        List<String> executeTimeByCron = CronUtils.getExecuteTimeByCron(cron, 2);
        Assert.isTrue((!executeTimeByCron.isEmpty() ? 1 : 0) != 0, () -> new SnailJobServerException("Expression parsing error.[{}]", cron));
        Assert.isTrue((executeTimeByCron.size() == 2 ? 1 : 0) != 0, () -> new SnailJobServerException("Expression must support multiple executions.[{}]", cron));
        LocalDateTime first = LocalDateTime.parse(executeTimeByCron.get(0), DateUtils.NORM_DATETIME_PATTERN);
        LocalDateTime second = LocalDateTime.parse(executeTimeByCron.get(1), DateUtils.NORM_DATETIME_PATTERN);
        Duration duration = Duration.between(first, second);
        return duration.toMillis();
    }
}

