/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.convert;

import com.aizuda.snailjob.server.common.convert.WorkflowConverter;
import com.aizuda.snailjob.server.common.vo.WorkflowBatchResponseVO;
import com.aizuda.snailjob.server.common.vo.WorkflowDetailResponseVO;
import com.aizuda.snailjob.server.common.vo.WorkflowResponseVO;
import com.aizuda.snailjob.server.common.vo.request.WorkflowRequestVO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.WorkflowBatchResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import java.util.ArrayList;
import java.util.List;

public class WorkflowConverterImpl
implements WorkflowConverter {
    @Override
    public Workflow convert(WorkflowRequestVO workflowRequestVO) {
        if (workflowRequestVO == null) {
            return null;
        }
        Workflow workflow = new Workflow();
        workflow.setId(workflowRequestVO.getId());
        workflow.setWorkflowName(workflowRequestVO.getWorkflowName());
        workflow.setGroupName(workflowRequestVO.getGroupName());
        workflow.setTriggerType(workflowRequestVO.getTriggerType());
        workflow.setBlockStrategy(workflowRequestVO.getBlockStrategy());
        workflow.setExecutorTimeout(workflowRequestVO.getExecutorTimeout());
        workflow.setWorkflowStatus(workflowRequestVO.getWorkflowStatus());
        workflow.setDescription(workflowRequestVO.getDescription());
        workflow.setWfContext(workflowRequestVO.getWfContext());
        workflow.setOwnerId(workflowRequestVO.getOwnerId());
        workflow.setNotifyIds(WorkflowConverter.toNotifyIdsStr(workflowRequestVO.getNotifyIds()));
        workflow.setTriggerInterval(WorkflowConverter.toTriggerInterval(workflowRequestVO));
        return workflow;
    }

    @Override
    public WorkflowNode convert(WorkflowRequestVO.NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setNodeName(nodeInfo.getNodeName());
        workflowNode.setFailStrategy(nodeInfo.getFailStrategy());
        workflowNode.setPriorityLevel(nodeInfo.getPriorityLevel());
        workflowNode.setWorkflowNodeStatus(nodeInfo.getWorkflowNodeStatus());
        return workflowNode;
    }

    @Override
    public WorkflowDetailResponseVO convert(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        WorkflowDetailResponseVO workflowDetailResponseVO = new WorkflowDetailResponseVO();
        workflowDetailResponseVO.setId(workflow.getId());
        workflowDetailResponseVO.setWorkflowName(workflow.getWorkflowName());
        workflowDetailResponseVO.setGroupName(workflow.getGroupName());
        workflowDetailResponseVO.setTriggerType(workflow.getTriggerType());
        workflowDetailResponseVO.setBlockStrategy(workflow.getBlockStrategy());
        workflowDetailResponseVO.setExecutorTimeout(workflow.getExecutorTimeout());
        workflowDetailResponseVO.setWorkflowStatus(workflow.getWorkflowStatus());
        workflowDetailResponseVO.setWfContext(workflow.getWfContext());
        workflowDetailResponseVO.setNotifyIds(WorkflowConverter.toNotifyIds(workflow.getNotifyIds()));
        workflowDetailResponseVO.setTriggerInterval(WorkflowConverter.toTriggerInterval(workflow));
        workflowDetailResponseVO.setOwnerId(WorkflowConverter.getOwnerId(workflow));
        return workflowDetailResponseVO;
    }

    @Override
    public WorkflowRequestVO convertToWorkflowRequestVo(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        WorkflowRequestVO workflowRequestVO = new WorkflowRequestVO();
        workflowRequestVO.setId(workflow.getId());
        workflowRequestVO.setGroupName(workflow.getGroupName());
        workflowRequestVO.setWorkflowName(workflow.getWorkflowName());
        workflowRequestVO.setTriggerType(workflow.getTriggerType());
        workflowRequestVO.setExecutorTimeout(workflow.getExecutorTimeout());
        workflowRequestVO.setBlockStrategy(workflow.getBlockStrategy());
        workflowRequestVO.setWfContext(workflow.getWfContext());
        workflowRequestVO.setWorkflowStatus(workflow.getWorkflowStatus());
        workflowRequestVO.setDescription(workflow.getDescription());
        workflowRequestVO.setOwnerId(workflow.getOwnerId());
        workflowRequestVO.setNotifyIds(WorkflowConverter.toNotifyIds(workflow.getNotifyIds()));
        workflowRequestVO.setTriggerInterval(WorkflowConverter.toTriggerInterval(workflow));
        return workflowRequestVO;
    }

    @Override
    public List<WorkflowDetailResponseVO.NodeInfo> convertList(List<WorkflowNode> workflowNodes) {
        if (workflowNodes == null) {
            return null;
        }
        ArrayList<WorkflowDetailResponseVO.NodeInfo> list = new ArrayList<WorkflowDetailResponseVO.NodeInfo>(workflowNodes.size());
        for (WorkflowNode workflowNode : workflowNodes) {
            list.add(this.convert(workflowNode));
        }
        return list;
    }

    @Override
    public WorkflowDetailResponseVO.NodeInfo convert(WorkflowNode workflowNode) {
        if (workflowNode == null) {
            return null;
        }
        WorkflowDetailResponseVO.NodeInfo nodeInfo = new WorkflowDetailResponseVO.NodeInfo();
        nodeInfo.setId(workflowNode.getId());
        nodeInfo.setNodeType(workflowNode.getNodeType());
        nodeInfo.setNodeName(workflowNode.getNodeName());
        nodeInfo.setPriorityLevel(workflowNode.getPriorityLevel());
        nodeInfo.setWorkflowNodeStatus(workflowNode.getWorkflowNodeStatus());
        nodeInfo.setFailStrategy(workflowNode.getFailStrategy());
        nodeInfo.setDecision(WorkflowConverter.parseDecisionConfig(workflowNode));
        nodeInfo.setCallback(WorkflowConverter.parseCallbackConfig(workflowNode));
        nodeInfo.setJobTask(WorkflowConverter.parseJobTaskConfig(workflowNode));
        return nodeInfo;
    }

    @Override
    public List<WorkflowResponseVO> convertListToWorkflowList(List<Workflow> workflowList) {
        if (workflowList == null) {
            return null;
        }
        ArrayList<WorkflowResponseVO> list = new ArrayList<WorkflowResponseVO>(workflowList.size());
        for (Workflow workflow : workflowList) {
            list.add(this.convertToWorkflow(workflow));
        }
        return list;
    }

    @Override
    public WorkflowResponseVO convertToWorkflow(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        WorkflowResponseVO workflowResponseVO = new WorkflowResponseVO();
        workflowResponseVO.setId(workflow.getId());
        workflowResponseVO.setWorkflowName(workflow.getWorkflowName());
        workflowResponseVO.setGroupName(workflow.getGroupName());
        workflowResponseVO.setTriggerType(workflow.getTriggerType());
        workflowResponseVO.setExecutorTimeout(workflow.getExecutorTimeout());
        workflowResponseVO.setWorkflowStatus(workflow.getWorkflowStatus());
        workflowResponseVO.setCreateDt(workflow.getCreateDt());
        workflowResponseVO.setUpdateDt(workflow.getUpdateDt());
        workflowResponseVO.setWfContext(workflow.getWfContext());
        workflowResponseVO.setOwnerId(workflow.getOwnerId());
        workflowResponseVO.setNextTriggerAt(WorkflowConverter.toLocalDateTime(workflow.getNextTriggerAt()));
        workflowResponseVO.setNotifyIds(WorkflowConverter.toNotifyIds(workflow.getNotifyIds()));
        workflowResponseVO.setTriggerInterval(WorkflowConverter.toTriggerInterval(workflow));
        return workflowResponseVO;
    }

    @Override
    public List<WorkflowBatchResponseVO> convertListToWorkflowBatchList(List<WorkflowBatchResponseDO> workflowBatchResponseList) {
        if (workflowBatchResponseList == null) {
            return null;
        }
        ArrayList<WorkflowBatchResponseVO> list = new ArrayList<WorkflowBatchResponseVO>(workflowBatchResponseList.size());
        for (WorkflowBatchResponseDO workflowBatchResponseDO : workflowBatchResponseList) {
            list.add(this.workflowBatchResponseDOToWorkflowBatchResponseVO(workflowBatchResponseDO));
        }
        return list;
    }

    @Override
    public WorkflowBatchResponseVO convert(WorkflowTaskBatch workflowTaskBatch, Workflow workflow) {
        if (workflowTaskBatch == null && workflow == null) {
            return null;
        }
        WorkflowBatchResponseVO workflowBatchResponseVO = new WorkflowBatchResponseVO();
        if (workflowTaskBatch != null) {
            workflowBatchResponseVO.setGroupName(workflowTaskBatch.getGroupName());
            workflowBatchResponseVO.setId(workflowTaskBatch.getId());
            workflowBatchResponseVO.setCreateDt(workflowTaskBatch.getCreateDt());
            workflowBatchResponseVO.setWorkflowId(workflowTaskBatch.getWorkflowId());
            workflowBatchResponseVO.setTaskBatchStatus(workflowTaskBatch.getTaskBatchStatus());
            workflowBatchResponseVO.setOperationReason(workflowTaskBatch.getOperationReason());
        }
        if (workflow != null) {
            workflowBatchResponseVO.setWorkflowName(workflow.getWorkflowName());
        }
        workflowBatchResponseVO.setExecutionAt(WorkflowConverter.toLocalDateTime(workflowTaskBatch.getExecutionAt()));
        return workflowBatchResponseVO;
    }

    protected WorkflowBatchResponseVO workflowBatchResponseDOToWorkflowBatchResponseVO(WorkflowBatchResponseDO workflowBatchResponseDO) {
        if (workflowBatchResponseDO == null) {
            return null;
        }
        WorkflowBatchResponseVO workflowBatchResponseVO = new WorkflowBatchResponseVO();
        workflowBatchResponseVO.setId(workflowBatchResponseDO.getId());
        workflowBatchResponseVO.setGroupName(workflowBatchResponseDO.getGroupName());
        workflowBatchResponseVO.setWorkflowId(workflowBatchResponseDO.getWorkflowId());
        workflowBatchResponseVO.setWorkflowName(workflowBatchResponseDO.getWorkflowName());
        workflowBatchResponseVO.setTaskBatchStatus(workflowBatchResponseDO.getTaskBatchStatus());
        workflowBatchResponseVO.setOperationReason(workflowBatchResponseDO.getOperationReason());
        workflowBatchResponseVO.setExecutionAt(WorkflowConverter.toLocalDateTime(workflowBatchResponseDO.getExecutionAt()));
        workflowBatchResponseVO.setCreateDt(workflowBatchResponseDO.getCreateDt());
        return workflowBatchResponseVO;
    }
}

