/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.server.netty;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.rpc.server.netty.NettyHttpServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import lombok.Generated;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class NettyHttpServer
implements Runnable,
Lifecycle {
    private final SystemProperties systemProperties;
    private Thread thread = null;
    private volatile boolean started = false;

    @Override
    public void run() {
        if (this.started) {
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x500000)}).addLast(new ChannelHandler[]{new NettyHttpServerHandler()});
                }
            });
            ChannelFuture future = bootstrap.bind(this.systemProperties.getServerPort()).sync();
            SnailJobLog.LOCAL.info("------> snail-job remoting server start success, nettype = {}, port = {}", new Object[]{NettyHttpServer.class.getName(), this.systemProperties.getServerPort()});
            this.started = true;
            future.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            SnailJobLog.LOCAL.info("--------> snail-job remoting server stop.", new Object[0]);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("--------> snail-job remoting server error.", new Object[]{e});
            this.started = false;
            throw new SnailJobServerException("snail-job server start error");
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    @Generated
    public NettyHttpServer(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Generated
    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    @Generated
    public Thread getThread() {
        return this.thread;
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }
}

