/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.allocate.client;

import com.aizuda.snailjob.server.common.ClientLoadBalance;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceConsistentHash;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceFirst;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceLRU;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceLast;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceRandom;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceRound;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import lombok.Generated;

public class ClientLoadBalanceManager {
    public static ClientLoadBalance getClientLoadBalance(int routeType) {
        for (AllocationAlgorithmEnum algorithmEnum : AllocationAlgorithmEnum.values()) {
            if (algorithmEnum.getType() != routeType) continue;
            return algorithmEnum.getClientLoadBalance();
        }
        throw new SnailJobServerException("routeType is not existed. routeType:[{}]", routeType);
    }

    public static enum AllocationAlgorithmEnum {
        CONSISTENT_HASH(1, new ClientLoadBalanceConsistentHash(100)),
        RANDOM(2, new ClientLoadBalanceRandom()),
        LRU(3, new ClientLoadBalanceLRU(100)),
        ROUND(4, new ClientLoadBalanceRound()),
        FIRST(5, new ClientLoadBalanceFirst()),
        LAST(6, new ClientLoadBalanceLast());

        private final int type;
        private final ClientLoadBalance clientLoadBalance;

        @Generated
        private AllocationAlgorithmEnum(int type, ClientLoadBalance clientLoadBalance) {
            this.type = type;
            this.clientLoadBalance = clientLoadBalance;
        }

        @Generated
        public int getType() {
            return this.type;
        }

        @Generated
        public ClientLoadBalance getClientLoadBalance() {
            return this.clientLoadBalance;
        }
    }
}

