/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.server;

import com.aizuda.snailjob.common.core.enums.RpcTypeEnum;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcResult;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcSnailJobRequest;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.rpc.server.GrpcInterceptor;
import com.aizuda.snailjob.server.common.rpc.server.UnaryRequestHandler;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.Message;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.util.MutableHandlerRegistry;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class GrpcServer
implements Lifecycle {
    private final SystemProperties systemProperties;
    private volatile boolean started = false;
    private Server server;

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        if (RpcTypeEnum.GRPC != this.systemProperties.getRpcType()) {
            return;
        }
        SystemProperties.RpcServerProperties grpc = this.systemProperties.getServerRpc();
        MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
        this.addServices(handlerRegistry, new GrpcInterceptor());
        NettyServerBuilder builder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.systemProperties.getServerPort()).executor((Executor)this.createGrpcExecutor(grpc.getDispatcherTp()));
        Duration keepAliveTime = grpc.getKeepAliveTime();
        Duration keepAliveTimeOut = grpc.getKeepAliveTimeout();
        Duration permitKeepAliveTime = grpc.getPermitKeepAliveTime();
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)builder.maxInboundMessageSize(grpc.getMaxInboundMessageSize()).fallbackHandlerRegistry((HandlerRegistry)handlerRegistry)).compressorRegistry(CompressorRegistry.getDefaultInstance())).decompressorRegistry(DecompressorRegistry.getDefaultInstance())).keepAliveTime(keepAliveTime.toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(keepAliveTimeOut.toMillis(), TimeUnit.MILLISECONDS).permitKeepAliveTime(permitKeepAliveTime.toMillis(), TimeUnit.MILLISECONDS).build();
        try {
            this.server.start();
            this.started = true;
            SnailJobLog.LOCAL.info("------> snail-job remoting server start success, grpc = {}, port = {}", new Object[]{GrpcServer.class.getName(), this.systemProperties.getServerPort()});
        }
        catch (IOException e) {
            SnailJobLog.LOCAL.error("--------> snail-job remoting server error.", new Object[]{e});
            this.started = false;
            throw new SnailJobServerException("snail-job server start error");
        }
    }

    @Override
    public void close() {
        if (this.server != null) {
            this.server.shutdownNow();
        }
    }

    private void addServices(MutableHandlerRegistry handlerRegistry, ServerInterceptor ... serverInterceptor) {
        ServerServiceDefinition serviceDefinition = GrpcServer.createUnaryServiceDefinition("UnaryRequest", "unaryRequest", new UnaryRequestHandler());
        handlerRegistry.addService(serviceDefinition);
        handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, (ServerInterceptor[])serverInterceptor));
    }

    public static ServerServiceDefinition createUnaryServiceDefinition(String serviceName, String methodName, ServerCalls.UnaryMethod<GrpcSnailJobRequest, GrpcResult> unaryMethod) {
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceName, (String)methodName)).setRequestMarshaller(ProtoUtils.marshaller((Message)GrpcSnailJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GrpcResult.getDefaultInstance())).build();
        return ServerServiceDefinition.builder((String)serviceName).addMethod(methodDescriptor, ServerCalls.asyncUnaryCall(unaryMethod)).build();
    }

    private ThreadPoolExecutor createGrpcExecutor(SystemProperties.ThreadPoolConfig threadPool) {
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(threadPool.getCorePoolSize(), threadPool.getMaximumPoolSize(), threadPool.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(threadPool.getQueueCapacity()), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("snail-job-grpc-server-executor-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }

    @Generated
    public GrpcServer(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Generated
    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    @Generated
    public Server getServer() {
        return this.server;
    }
}

