/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.server;

import akka.actor.AbstractActor;
import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcResult;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcSnailJobRequest;
import com.aizuda.snailjob.common.core.grpc.auto.Metadata;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.HttpRequestHandler;
import com.aizuda.snailjob.server.common.cache.CacheToken;
import com.aizuda.snailjob.server.common.dto.GrpcRequest;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import io.grpc.stub.StreamObserver;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="GrpcRequestHandlerActor")
@Scope(value="prototype")
public class GrpcRequestHandlerActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcRequestHandlerActor.class);

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(GrpcRequest.class, grpcRequest -> {
            GrpcSnailJobRequest grpcSnailJobRequest = grpcRequest.getSnailJobRequest();
            Metadata metadata = grpcSnailJobRequest.getMetadata();
            String uri = metadata.getUri();
            if (StrUtil.isBlank((CharSequence)uri)) {
                SnailJobLog.LOCAL.error("uri can not be null", new Object[0]);
                return;
            }
            Map headersMap = metadata.getHeadersMap();
            SnailJobRpcResult snailJobRpcResult = null;
            try {
                SnailJobRequest request = new SnailJobRequest();
                String body = grpcSnailJobRequest.getBody();
                Object[] objects = (Object[])JsonUtil.parseObject((String)body, Object[].class);
                request.setArgs(objects);
                request.setReqId(grpcSnailJobRequest.getReqId());
                snailJobRpcResult = this.doProcess(uri, JsonUtil.toJsonString((Object)request), headersMap);
                if (Objects.isNull(snailJobRpcResult)) {
                    snailJobRpcResult = new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), "\u670d\u52a1\u7aef\u5f02\u5e38", null, grpcSnailJobRequest.getReqId());
                }
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("http request error. [{}]", new Object[]{grpcSnailJobRequest, e});
                snailJobRpcResult = new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), e.getMessage(), null, grpcSnailJobRequest.getReqId());
            }
            finally {
                StreamObserver<GrpcResult> streamObserver = grpcRequest.getStreamObserver();
                GrpcResult grpcResult = GrpcResult.newBuilder().setReqId(snailJobRpcResult.getReqId()).setStatus(snailJobRpcResult.getStatus()).setMessage(Optional.ofNullable(snailJobRpcResult.getMessage()).orElse("")).setData(JsonUtil.toJsonString((Object)snailJobRpcResult.getData())).build();
                streamObserver.onNext((Object)grpcResult);
                streamObserver.onCompleted();
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private SnailJobRpcResult doProcess(String uri, String content, Map<String, String> headersMap) {
        String groupName = headersMap.get(HeadersEnum.GROUP_NAME.getKey());
        String namespace = headersMap.get(HeadersEnum.NAMESPACE.getKey());
        String token = headersMap.get(HeadersEnum.TOKEN.getKey());
        if (StrUtil.isBlank((CharSequence)token) || !CacheToken.get(groupName, namespace).equals(token)) {
            throw new SnailJobServerException("Token authentication failed. [namespace:{} groupName:{} token:{}]", namespace, groupName, token);
        }
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headersMap.forEach((arg_0, arg_1) -> ((DefaultHttpHeaders)headers).add(arg_0, arg_1));
        UrlBuilder builder = UrlBuilder.ofHttp((String)uri);
        Collection httpRequestHandlers = SnailSpringContext.getContext().getBeansOfType(HttpRequestHandler.class).values();
        for (HttpRequestHandler httpRequestHandler : httpRequestHandlers) {
            if (!httpRequestHandler.supports(builder.getPathStr())) continue;
            return httpRequestHandler.doHandler(content, builder, (HttpHeaders)headers);
        }
        throw new SnailJobServerException("No matching handler found. Path:[{}] method:[{}]", builder.getPathStr());
    }
}

