/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.alarm;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.AlarmInfoConverter;
import com.aizuda.snailjob.server.common.alarm.AbstractAlarm;
import com.aizuda.snailjob.server.common.dto.WorkflowAlarmInfo;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.WorkflowBatchResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractWorkflowAlarm<E extends ApplicationEvent>
extends AbstractAlarm<E, WorkflowAlarmInfo> {
    @Autowired
    private WorkflowTaskBatchMapper workflowTaskBatchMapper;

    @Override
    protected Map<Long, List<WorkflowAlarmInfo>> convertAlarmDTO(List<WorkflowAlarmInfo> workflowAlarmInfoList, Set<Integer> notifyScene) {
        HashMap<Long, List<WorkflowAlarmInfo>> workflowAlarmInfoMap = new HashMap<Long, List<WorkflowAlarmInfo>>();
        workflowAlarmInfoList.forEach(i -> notifyScene.add(i.getNotifyScene()));
        Map workflowAlarmInfoGroupMap = workflowAlarmInfoList.stream().collect(Collectors.toMap(i -> i.getId(), Function.identity()));
        List workflowBatchResponseDOList = this.workflowTaskBatchMapper.selectWorkflowBatchList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"batch.id", (Collection)workflowAlarmInfoList.stream().map(i -> i.getId()).collect(Collectors.toSet()))).eq((Object)"batch.deleted", (Object)0));
        for (WorkflowBatchResponseDO workflowBatchResponseDO : workflowBatchResponseDOList) {
            HashSet workflowNotifyIds = StrUtil.isBlank((CharSequence)workflowBatchResponseDO.getNotifyIds()) ? new HashSet() : new HashSet(JsonUtil.parseList((String)workflowBatchResponseDO.getNotifyIds(), Long.class));
            for (Long workflowNotifyId : workflowNotifyIds) {
                WorkflowAlarmInfo workflowAlarmInfo = AlarmInfoConverter.INSTANCE.toWorkflowAlarmInfo(workflowBatchResponseDO);
                WorkflowAlarmInfo alarmInfo = (WorkflowAlarmInfo)workflowAlarmInfoGroupMap.get(workflowAlarmInfo.getId());
                workflowAlarmInfo.setReason(alarmInfo.getReason());
                workflowAlarmInfo.setNotifyScene(alarmInfo.getNotifyScene());
                List<WorkflowAlarmInfo> workflowAlarmInfos = workflowAlarmInfoMap.getOrDefault(workflowNotifyId, Lists.newArrayList());
                workflowAlarmInfos.add(workflowAlarmInfo);
                workflowAlarmInfoMap.put(workflowNotifyId, workflowAlarmInfos);
            }
        }
        return workflowAlarmInfoMap;
    }
}

