/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.lock;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.lock.DisposableLockProvider;
import com.aizuda.snailjob.server.common.lock.LockManager;
import com.aizuda.snailjob.server.common.lock.LockProvider;
import com.aizuda.snailjob.server.common.lock.ResidentLockProvider;

public final class LockBuilder {
    private String lockName;
    private boolean resident;

    public static LockBuilder newBuilder() {
        return new LockBuilder();
    }

    public LockBuilder withResident(String lockName) {
        this.lockName = lockName;
        this.resident = Boolean.TRUE;
        return this;
    }

    public LockBuilder withDisposable(String lockName) {
        this.lockName = lockName;
        this.resident = Boolean.FALSE;
        return this;
    }

    public LockProvider build() {
        Assert.notBlank((CharSequence)this.lockName, () -> new SnailJobServerException("lockName can not be null."));
        LockManager.initialize();
        LockManager.setLockName(this.lockName);
        if (this.resident) {
            return new ResidentLockProvider();
        }
        return new DisposableLockProvider();
    }
}

