/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.cache;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheNotifyRateLimiter
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(CacheNotifyRateLimiter.class);
    private static Cache<String, RateLimiter> CACHE;

    public static Cache<String, RateLimiter> getAll() {
        return CACHE;
    }

    public static RateLimiter getRateLimiterByKey(String key) {
        return (RateLimiter)CACHE.getIfPresent((Object)key);
    }

    public static void put(String key, RateLimiter rateLimiter) {
        CACHE.put((Object)key, (Object)rateLimiter);
    }

    @Override
    public void start() {
        SnailJobLog.LOCAL.info("CacheNotifyRateLimiter start", new Object[0]);
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite(30L, TimeUnit.MINUTES).build();
    }

    @Override
    public void close() {
        SnailJobLog.LOCAL.info("CacheNotifyRateLimiter stop", new Object[0]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheNotifyRateLimiter)) {
            return false;
        }
        CacheNotifyRateLimiter other = (CacheNotifyRateLimiter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheNotifyRateLimiter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "CacheNotifyRateLimiter()";
    }
}

