/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.alarm;

import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.alarm.AbstractAlarm;
import com.aizuda.snailjob.server.common.dto.JobAlarmInfo;
import com.aizuda.snailjob.server.common.triple.ImmutableTriple;
import com.aizuda.snailjob.server.common.triple.Triple;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractJobAlarm<E extends ApplicationEvent>
extends AbstractAlarm<E, JobAlarmInfo> {
    @Override
    protected Map<Triple<String, String, String>, List<JobAlarmInfo>> convertAlarmDTO(List<JobAlarmInfo> alarmInfos, Set<String> namespaceIds, Set<String> groupNames, Set<String> jobIds) {
        return StreamUtils.groupByKey(alarmInfos, alarmInfo -> {
            String namespaceId = alarmInfo.getNamespaceId();
            String groupName = alarmInfo.getGroupName();
            String jobId = String.valueOf(alarmInfo.getJobId());
            namespaceIds.add(namespaceId);
            groupNames.add(groupName);
            jobIds.add(jobId);
            return ImmutableTriple.of(namespaceId, groupName, jobId);
        });
    }
}

