/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.dto.JobAlarmInfo;
import com.aizuda.snailjob.server.common.dto.NotifyConfigInfo;
import com.aizuda.snailjob.server.common.dto.RetryAlarmInfo;
import com.aizuda.snailjob.server.common.dto.WorkflowAlarmInfo;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.JobBatchResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.WorkflowBatchResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.po.JobNotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface AlarmInfoConverter {
    public static final AlarmInfoConverter INSTANCE = (AlarmInfoConverter)Mappers.getMapper(AlarmInfoConverter.class);

    @Mappings(value={@Mapping(source="retryCount", target="count")})
    public List<RetryAlarmInfo> retryTaskToAlarmInfo(List<RetryTask> var1);

    @Mappings(value={@Mapping(source="retryCount", target="count")})
    public RetryAlarmInfo retryTaskToAlarmInfo(RetryTask var1);

    public List<RetryAlarmInfo> deadLetterToAlarmInfo(List<RetryDeadLetter> var1);

    public List<NotifyConfigInfo> retryToNotifyConfigInfos(List<NotifyConfig> var1);

    @Mappings(value={@Mapping(target="recipientIds", expression="java(AlarmInfoConverter.toNotifyRecipientIds(notifyConfig.getRecipientIds()))")})
    public NotifyConfigInfo retryToNotifyConfigInfos(NotifyConfig var1);

    public static Set<Long> toNotifyRecipientIds(String notifyRecipientIdsStr) {
        if (StrUtil.isBlank((CharSequence)notifyRecipientIdsStr)) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(JsonUtil.parseList((String)notifyRecipientIdsStr, Long.class));
    }

    public List<NotifyConfigInfo> jobToNotifyConfigInfos(List<JobNotifyConfig> var1);

    public List<JobAlarmInfo> toJobAlarmInfos(List<JobBatchResponseDO> var1);

    public List<WorkflowAlarmInfo> toWorkflowAlarmInfos(List<WorkflowBatchResponseDO> var1);
}

