/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.template.datasource.access.config;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.NodeTypeEnum;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.model.dto.ConfigDTO;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.enums.DbTypeEnum;
import com.aizuda.snailjob.template.datasource.persistence.mapper.GroupConfigMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyConfigMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyRecipientMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SceneConfigMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyRecipient;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.utils.DbUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractConfigAccess<T>
implements ConfigAccess<T> {
    @Autowired
    protected NotifyConfigMapper notifyConfigMapper;
    @Autowired
    protected SceneConfigMapper sceneConfigMapper;
    @Autowired
    protected GroupConfigMapper groupConfigMapper;
    @Autowired
    protected NotifyRecipientMapper notifyRecipientMapper;
    protected static final List<String> ALLOW_DB = Arrays.asList(DbTypeEnum.MYSQL.getDb(), DbTypeEnum.MARIADB.getDb(), DbTypeEnum.POSTGRES.getDb(), DbTypeEnum.ORACLE.getDb(), DbTypeEnum.SQLSERVER.getDb(), DbTypeEnum.DM.getDb(), DbTypeEnum.KINGBASE.getDb());

    protected DbTypeEnum getDbType() {
        return DbUtils.getDbType();
    }

    protected RetrySceneConfig getByGroupNameAndSceneName(String groupName, String sceneName, String namespaceId) {
        return (RetrySceneConfig)this.sceneConfigMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getGroupName, (Object)groupName)).eq(RetrySceneConfig::getSceneName, (Object)sceneName));
    }

    protected List<RetrySceneConfig> getSceneConfigs(String groupName) {
        return this.sceneConfigMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getGroupName, (Object)groupName));
    }

    protected GroupConfig getByGroupName(String groupName, String namespaceId) {
        return (GroupConfig)this.groupConfigMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupName, (Object)groupName));
    }

    protected List<NotifyConfig> getNotifyConfigs(String groupName, String namespaceId) {
        return this.notifyConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getNamespaceId, (Object)namespaceId)).eq(NotifyConfig::getGroupName, (Object)groupName)).eq(NotifyConfig::getNotifyStatus, (Object)StatusEnum.YES.getStatus()));
    }

    @Override
    public GroupConfig getGroupConfigByGroupName(String groupName, String namespaceId) {
        return this.getByGroupName(groupName, namespaceId);
    }

    @Override
    public RetrySceneConfig getSceneConfigByGroupNameAndSceneName(String groupName, String sceneName, String namespaceId) {
        return this.getByGroupNameAndSceneName(groupName, sceneName, namespaceId);
    }

    @Override
    public List<NotifyConfig> getNotifyListConfigByGroupName(String groupName, String namespaceId) {
        return this.getNotifyConfigs(groupName, namespaceId);
    }

    @Override
    public List<RetrySceneConfig> getSceneConfigByGroupName(String groupName) {
        return this.getSceneConfigs(groupName);
    }

    @Override
    public Set<String> getBlacklist(String groupName, String namespaceId) {
        List retrySceneConfigs;
        GroupConfig groupConfig = this.getByGroupName(groupName, namespaceId);
        if (Objects.isNull(groupConfig)) {
            return new HashSet<String>();
        }
        LambdaQueryWrapper sceneConfigLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{RetrySceneConfig::getSceneName}).eq(RetrySceneConfig::getGroupName, (Object)groupName);
        if (StatusEnum.YES.getStatus().equals(groupConfig.getGroupStatus())) {
            sceneConfigLambdaQueryWrapper.eq(RetrySceneConfig::getSceneStatus, (Object)StatusEnum.NO.getStatus());
        }
        if (CollUtil.isEmpty((Collection)(retrySceneConfigs = this.sceneConfigMapper.selectList((Wrapper)sceneConfigLambdaQueryWrapper)))) {
            return new HashSet<String>();
        }
        return retrySceneConfigs.stream().map(RetrySceneConfig::getSceneName).collect(Collectors.toSet());
    }

    @Override
    public List<GroupConfig> getAllConfigGroupList(String namespaceId) {
        List allSystemConfigGroupList = this.groupConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).orderByAsc(GroupConfig::getId));
        if (CollUtil.isEmpty((Collection)allSystemConfigGroupList)) {
            return new ArrayList<GroupConfig>();
        }
        return allSystemConfigGroupList;
    }

    @Override
    public List<RetrySceneConfig> getAllConfigSceneList() {
        List allSystemConfigSceneList = this.sceneConfigMapper.selectList((Wrapper)new LambdaQueryWrapper().orderByAsc(RetrySceneConfig::getId));
        if (CollUtil.isEmpty((Collection)allSystemConfigSceneList)) {
            return new ArrayList<RetrySceneConfig>();
        }
        return allSystemConfigSceneList;
    }

    @Override
    public Integer getConfigVersion(String groupName, String namespaceId) {
        GroupConfig groupConfig = this.getGroupConfigByGroupName(groupName, namespaceId);
        if (Objects.isNull(groupConfig)) {
            return 0;
        }
        return groupConfig.getVersion();
    }

    @Override
    public ConfigDTO getConfigInfo(String groupName, String namespaceId) {
        ConfigDTO configDTO = new ConfigDTO();
        configDTO.setVersion(this.getConfigVersion(groupName, namespaceId));
        List<NotifyConfig> notifyList = this.getNotifyListConfigByGroupName(groupName, namespaceId);
        ArrayList<ConfigDTO.Notify> notifies = new ArrayList<ConfigDTO.Notify>();
        for (NotifyConfig notifyConfig : notifyList) {
            RetryNotifySceneEnum retryNotifyScene = RetryNotifySceneEnum.getNotifyScene((int)notifyConfig.getNotifyScene(), (NodeTypeEnum)NodeTypeEnum.CLIENT);
            JobNotifySceneEnum jobNotifyScene = JobNotifySceneEnum.getJobNotifyScene((int)notifyConfig.getNotifyScene(), (NodeTypeEnum)NodeTypeEnum.CLIENT);
            if (Objects.isNull(retryNotifyScene) && Objects.isNull(jobNotifyScene)) continue;
            String recipientIds = notifyConfig.getRecipientIds();
            List notifyRecipients = this.notifyRecipientMapper.selectBatchIds(JsonUtil.parseList((String)recipientIds, Long.class));
            notifies.add(AbstractConfigAccess.getNotify(notifyConfig, notifyRecipients, retryNotifyScene, jobNotifyScene));
        }
        configDTO.setNotifyList(notifies);
        List<RetrySceneConfig> retrySceneConfig = this.getSceneConfigByGroupName(groupName);
        ArrayList<ConfigDTO.Scene> sceneList = new ArrayList<ConfigDTO.Scene>();
        for (RetrySceneConfig config : retrySceneConfig) {
            ConfigDTO.Scene scene = new ConfigDTO.Scene();
            scene.setSceneName(config.getSceneName());
            scene.setDdl(config.getDeadlineRequest().longValue());
            sceneList.add(scene);
        }
        configDTO.setSceneList(sceneList);
        return configDTO;
    }

    private static ConfigDTO.Notify getNotify(NotifyConfig notifyConfig, List<NotifyRecipient> notifyRecipients, RetryNotifySceneEnum retryNotifyScene, JobNotifySceneEnum jobNotifyScene) {
        ArrayList<ConfigDTO.Notify.Recipient> recipients = new ArrayList<ConfigDTO.Notify.Recipient>();
        for (NotifyRecipient notifyRecipient : notifyRecipients) {
            ConfigDTO.Notify.Recipient recipient = new ConfigDTO.Notify.Recipient();
            recipient.setNotifyAttribute(notifyRecipient.getNotifyAttribute());
            recipient.setNotifyType(notifyRecipient.getNotifyType());
            recipients.add(recipient);
        }
        ConfigDTO.Notify notify = new ConfigDTO.Notify();
        if (Objects.nonNull(retryNotifyScene)) {
            notify.setRetryNotifyScene(Integer.valueOf(retryNotifyScene.getNotifyScene()));
        }
        if (Objects.nonNull(jobNotifyScene)) {
            notify.setJobNotifyScene(Integer.valueOf(jobNotifyScene.getNotifyScene()));
        }
        notify.setNotifyThreshold(notifyConfig.getNotifyThreshold());
        notify.setRecipients(recipients);
        return notify;
    }
}

