/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.template.datasource.access.task;

import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.enums.DbTypeEnum;
import com.aizuda.snailjob.template.datasource.utils.DbUtils;
import com.aizuda.snailjob.template.datasource.utils.RequestDataHelper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTaskAccess<T>
implements TaskAccess<T> {
    protected static final List<String> ALLOW_DB = Arrays.asList(DbTypeEnum.MYSQL.getDb(), DbTypeEnum.MARIADB.getDb(), DbTypeEnum.POSTGRES.getDb(), DbTypeEnum.ORACLE.getDb(), DbTypeEnum.SQLSERVER.getDb());

    protected DbTypeEnum getDbType() {
        return DbUtils.getDbType();
    }

    public void setPartition(String groupName, String namespaceId) {
        RequestDataHelper.setPartition(groupName, namespaceId);
    }

    @Override
    public List<T> list(String groupName, String namespaceId, LambdaQueryWrapper<T> query) {
        this.setPartition(groupName, namespaceId);
        return this.doList(query);
    }

    @Override
    public int update(String groupName, String namespaceId, T t, LambdaUpdateWrapper<T> query) {
        this.setPartition(groupName, namespaceId);
        return this.doUpdate(t, query);
    }

    protected abstract int doUpdate(T var1, LambdaUpdateWrapper<T> var2);

    @Override
    public int updateById(String groupName, String namespaceId, T t) {
        this.setPartition(groupName, namespaceId);
        return this.doUpdateById(t);
    }

    @Override
    public int delete(String groupName, String namespaceId, LambdaQueryWrapper<T> query) {
        this.setPartition(groupName, namespaceId);
        return this.doDelete(query);
    }

    @Override
    public int insert(String groupName, String namespaceId, T t) {
        this.setPartition(groupName, namespaceId);
        return this.doInsert(t);
    }

    @Override
    public int batchInsert(String groupName, String namespaceId, List<T> list) {
        this.setPartition(groupName, namespaceId);
        return this.doBatchInsert(list);
    }

    protected abstract int doBatchInsert(List<T> var1);

    @Override
    public PageDTO<T> listPage(String groupName, String namespaceId, PageDTO<T> iPage, LambdaQueryWrapper<T> query) {
        this.setPartition(groupName, namespaceId);
        return this.doListPage(iPage, query);
    }

    @Override
    public T one(String groupName, String namespaceId, LambdaQueryWrapper<T> query) {
        this.setPartition(groupName, namespaceId);
        return this.doOne(query);
    }

    protected abstract T doOne(LambdaQueryWrapper<T> var1);

    protected abstract PageDTO<T> doListPage(PageDTO<T> var1, LambdaQueryWrapper<T> var2);

    @Override
    public long count(String groupName, String namespaceId, LambdaQueryWrapper<T> query) {
        this.setPartition(groupName, namespaceId);
        return this.doCount(query);
    }

    protected abstract long doCount(LambdaQueryWrapper<T> var1);

    protected abstract int doInsert(T var1);

    protected abstract int doDelete(LambdaQueryWrapper<T> var1);

    protected abstract int doUpdateById(T var1);

    protected abstract List<T> doList(LambdaQueryWrapper<T> var1);
}

