/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.util;

import com.aizuda.snailjob.common.log.SnailJobLog;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetUtil {
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final String ANY_HOST_VALUE = "0.0.0.0";
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final String URL_IPV4 = "http://{0}:{1}/{2}";
    private static final String URL_IPV6 = "http://[{0}]:{1}/{2}";
    private static volatile InetAddress LOCAL_ADDRESS = null;

    public static String getUrl(String host, int port, String contextPath) {
        String url = URL_IPV4;
        if (NetUtil.isValidIpV6(host)) {
            url = URL_IPV6;
        }
        return MessageFormat.format(url, host, String.valueOf(port), contextPath);
    }

    public static String getLocalIpStr() {
        return NetUtil.getLocalAddress().getHostAddress();
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtil.getLocalAddress0();
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            Optional<InetAddress> addressOp = NetUtil.toValidAddress(localAddress);
            if (addressOp.isPresent()) {
                return addressOp.get();
            }
        }
        catch (Throwable e) {
            SnailJobLog.LOCAL.warn("get local address error", new Object[]{e});
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                try {
                    NetworkInterface network = interfaces.nextElement();
                    if (network.isLoopback() || network.isVirtual() || !network.isUp()) continue;
                    Enumeration<InetAddress> addresses = network.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        try {
                            Optional<InetAddress> addressOp = NetUtil.toValidAddress(addresses.nextElement());
                            if (!addressOp.isPresent()) continue;
                            try {
                                if (!addressOp.get().isReachable(100)) continue;
                                return addressOp.get();
                            }
                            catch (IOException iOException) {
                            }
                        }
                        catch (Throwable e) {
                            SnailJobLog.LOCAL.warn("get local address error", new Object[]{e});
                        }
                    }
                }
                catch (Throwable e) {
                    SnailJobLog.LOCAL.warn("get local address error", new Object[]{e});
                }
            }
        }
        catch (Throwable e) {
            SnailJobLog.LOCAL.warn("get local address error", new Object[]{e});
        }
        return localAddress;
    }

    private static Optional<InetAddress> toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (NetUtil.isPreferIPV6Address()) {
                return Optional.ofNullable(NetUtil.normalizeV6Address(v6Address));
            }
        }
        if (NetUtil.isValidV4Address(address)) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IP_PATTERN.matcher(name).matches() && !ANY_HOST_VALUE.equals(name) && !LOCAL_HOST.equals(name);
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + "%" + address.getScopeId());
            }
            catch (UnknownHostException e) {
                SnailJobLog.LOCAL.debug("Unknown IPV6 address: ", new Object[]{e});
            }
        }
        return address;
    }

    static boolean isPreferIPV6Address() {
        boolean preferIpv6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
        if (!preferIpv6) {
            return false;
        }
        return false;
    }

    private static boolean isValidIpV4(String host) {
        Pattern pattern = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        Matcher matcher = pattern.matcher(host);
        return matcher.matches();
    }

    private static boolean isValidIpV6(String host) {
        Pattern pattern = Pattern.compile("^([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        Matcher matcher = pattern.matcher(host);
        return matcher.matches();
    }
}

