/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.strategy;

import com.aizuda.snailjob.client.core.RetryExecutor;
import com.aizuda.snailjob.client.core.RetryExecutorParameter;
import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.client.core.retryer.RetryType;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.client.core.retryer.RetryerResultContext;
import com.aizuda.snailjob.client.core.strategy.AbstractRetryStrategies;
import com.aizuda.snailjob.common.core.enums.RetryResultStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LocalRetryStrategies
extends AbstractRetryStrategies {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalRetryStrategies.class);

    @Override
    public boolean supports(int stage, RetryType retryType) {
        return RetrySiteSnapshot.EnumStage.LOCAL.getStage() == stage;
    }

    @Override
    protected void setStage() {
        RetrySiteSnapshot.setStage(RetrySiteSnapshot.EnumStage.LOCAL.getStage());
    }

    @Override
    protected Consumer<Object> doRetrySuccessConsumer(RetryerResultContext context) {
        return o -> {
            RetryerInfo retryerInfo = context.getRetryerInfo();
            if (retryerInfo.getRetryType() == RetryType.ONLY_REMOTE) {
                context.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
            } else {
                SnailJobLog.LOCAL.debug("doRetrySuccessConsumer retry successful", new Object[0]);
            }
        };
    }

    @Override
    protected void error(RetryerResultContext context) {
        context.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
    }

    @Override
    protected boolean preValidator(RetryerInfo retryerInfo, RetryerResultContext resultContext) {
        if (RetrySiteSnapshot.isRunning()) {
            resultContext.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
            resultContext.setMessage("Retry validation failed: reason: there is an ongoing retry task");
            return false;
        }
        if (RetrySiteSnapshot.isRetryForStatusCode()) {
            resultContext.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
            resultContext.setMessage("Retry validation failed: reason: downstream flag prohibits retry");
            return false;
        }
        return true;
    }

    @Override
    protected void unexpectedError(Exception e, RetryerResultContext retryerResultContext) {
        retryerResultContext.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
    }

    @Override
    protected void success(RetryerResultContext retryerResultContext) {
        retryerResultContext.setRetryResultStatusEnum(RetryResultStatusEnum.SUCCESS);
    }

    @Override
    public Consumer<Throwable> doGetRetryErrorConsumer(RetryerInfo retryerInfo, Object[] params) {
        return throwable -> {
            log.info("Memory retry completed but the exception was not resolved scene:[{}]", (Object)retryerInfo.getScene());
            if (RetryType.LOCAL_REMOTE.name().equals(retryerInfo.getRetryType().name())) {
                log.debug("Report scene:[{}]", (Object)retryerInfo.getScene());
                this.doReport(retryerInfo, params);
            }
        };
    }

    @Override
    public Callable doGetCallable(RetryExecutor<WaitStrategy, StopStrategy> retryExecutor, Object ... params) {
        RetryerInfo retryerInfo = retryExecutor.getRetryerInfo();
        RetryType retryType = retryerInfo.getRetryType();
        switch (retryType) {
            case ONLY_LOCAL: 
            case LOCAL_REMOTE: {
                RetrySiteSnapshot.setEntryMethodTime(System.currentTimeMillis());
                return () -> retryExecutor.execute(params);
            }
            case ONLY_REMOTE: {
                log.debug("Report scene:[{}]", (Object)retryerInfo.getScene());
                this.doReport(retryerInfo, params);
                RetrySiteSnapshot.setStage(RetrySiteSnapshot.EnumStage.REMOTE.getStage());
                return () -> null;
            }
        }
        throw new SnailRetryClientException("Exception retry mode [{}]", (Object)retryType.name());
    }

    @Override
    public RetryExecutorParameter<WaitStrategy, StopStrategy> getRetryExecutorParameter(final RetryerInfo retryerInfo) {
        return new RetryExecutorParameter<WaitStrategy, StopStrategy>(){

            @Override
            public WaitStrategy backOff() {
                return WaitStrategies.fixedWait((long)retryerInfo.getLocalInterval().intValue(), (TimeUnit)TimeUnit.SECONDS);
            }

            @Override
            public StopStrategy stop() {
                return StopStrategies.stopAfterAttempt((int)retryerInfo.getLocalTimes());
            }

            @Override
            public List<RetryListener> getRetryListeners() {
                return Collections.singletonList(new RetryListener(){

                    public <V> void onRetry(Attempt<V> attempt) {
                        if (attempt.hasException()) {
                            RetryType retryType = retryerInfo.getRetryType();
                            switch (retryType) {
                                case ONLY_LOCAL: 
                                case LOCAL_REMOTE: {
                                    SnailJobLog.LOCAL.error("Local retry for [{}] failed, retry number [{}]", new Object[]{retryerInfo.getScene(), attempt.getAttemptNumber()});
                                    break;
                                }
                                case ONLY_REMOTE: {
                                    SnailJobLog.LOCAL.error("Report service end execution for [{}] failed, retry number [{}]", new Object[]{retryerInfo.getScene(), attempt.getAttemptNumber()});
                                    break;
                                }
                                default: {
                                    throw new SnailRetryClientException("Exception retry mode [{}]", (Object)retryType.name());
                                }
                            }
                        } else {
                            RetryType retryType = retryerInfo.getRetryType();
                            switch (retryType) {
                                case ONLY_LOCAL: 
                                case LOCAL_REMOTE: {
                                    SnailJobLog.LOCAL.info("Local retry for [{}] successful.", new Object[]{retryerInfo.getScene()});
                                    break;
                                }
                                case ONLY_REMOTE: {
                                    SnailJobLog.LOCAL.info("Report service end execution for [{}] successful.", new Object[]{retryerInfo.getScene()});
                                    break;
                                }
                                default: {
                                    throw new SnailRetryClientException("Exception retry mode [{}]", (Object)retryType.name());
                                }
                            }
                        }
                    }
                });
            }
        };
    }
}

