/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.executor;

import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.core.context.RemoteRetryContext;
import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.client.core.log.RetryLogMeta;
import com.aizuda.snailjob.client.core.retryer.RetryerResultContext;
import com.aizuda.snailjob.client.core.strategy.RetryStrategy;
import com.aizuda.snailjob.client.model.DispatchRetryResultDTO;
import com.aizuda.snailjob.common.core.enums.RetryResultStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class RemoteRetryExecutor {
    private final RetryStrategy remoteRetryStrategies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatchRetryResultDTO doRetry(RemoteRetryContext context) {
        DispatchRetryResultDTO executeRespDto = new DispatchRetryResultDTO();
        executeRespDto.setRetryId(context.getRetryId());
        executeRespDto.setRetryTaskId(context.getRetryTaskId());
        executeRespDto.setNamespaceId(context.getNamespaceId());
        executeRespDto.setGroupName(context.getGroupName());
        executeRespDto.setSceneName(context.getScene());
        try {
            RetrySiteSnapshot.setAttemptNumber(context.getRetryCount());
            RemoteRetryExecutor.initLogContext(context);
            RetryerResultContext retryerResultContext = this.remoteRetryStrategies.openRetry(context.getScene(), context.getExecutorName(), context.getDeSerialize());
            if (RetrySiteSnapshot.isRetryForStatusCode()) {
                executeRespDto.setStatusCode(RetryResultStatusEnum.STOP.getStatus());
                executeRespDto.setExceptionMsg("\u4e0b\u6e38\u6807\u8bb0\u4e0d\u9700\u8981\u91cd\u8bd5");
            } else {
                RetryResultStatusEnum retryResultStatusEnum = retryerResultContext.getRetryResultStatusEnum();
                if (Objects.isNull(retryResultStatusEnum)) {
                    retryResultStatusEnum = RetryResultStatusEnum.STOP;
                    retryerResultContext.setMessage("\u672a\u83b7\u53d6\u91cd\u8bd5\u72b6\u6001. \u4efb\u52a1\u505c\u6b62");
                }
                executeRespDto.setStatusCode(retryResultStatusEnum.getStatus());
                executeRespDto.setExceptionMsg(retryerResultContext.getMessage());
            }
            if (Objects.nonNull(retryerResultContext.getResult())) {
                executeRespDto.setResultJson(JsonUtil.toJsonString((Object)retryerResultContext.getResult()));
            }
            if (Objects.equals(RetryResultStatusEnum.SUCCESS.getStatus(), executeRespDto.getStatusCode())) {
                SnailJobLog.REMOTE.info("remote retry\u3010SUCCESS\u3011. count:[{}] result:[{}]", new Object[]{context.getRetryCount(), executeRespDto.getResultJson()});
            } else if (Objects.equals(RetryResultStatusEnum.STOP.getStatus(), executeRespDto.getStatusCode())) {
                SnailJobLog.REMOTE.warn("remote retry \u3010STOP\u3011. count:[{}] exceptionMsg:[{}]", new Object[]{context.getRetryCount(), executeRespDto.getExceptionMsg()});
            } else if (Objects.equals(RetryResultStatusEnum.FAILURE.getStatus(), executeRespDto.getStatusCode())) {
                SnailJobLog.REMOTE.error("remote retry \u3010FAILURE\u3011. count:[{}] ", new Object[]{context.getRetryCount(), retryerResultContext.getThrowable()});
            } else {
                SnailJobLog.REMOTE.error("remote retry \u3010UNKNOWN\u3011. count:[{}] result:[{}]", new Object[]{context.getRetryCount(), executeRespDto.getResultJson(), retryerResultContext.getThrowable()});
            }
        }
        finally {
            RetrySiteSnapshot.removeAll();
            SnailJobLogManager.removeAll();
        }
        return executeRespDto;
    }

    private static void initLogContext(RemoteRetryContext context) {
        RetryLogMeta retryLogMeta = new RetryLogMeta();
        retryLogMeta.setGroupName(context.getGroupName());
        retryLogMeta.setNamespaceId(context.getNamespaceId());
        retryLogMeta.setRetryId(context.getRetryId());
        retryLogMeta.setRetryTaskId(context.getRetryTaskId());
        SnailJobLogManager.initLogInfo((LogMeta)retryLogMeta, (LogTypeEnum)LogTypeEnum.RETRY);
    }

    @Generated
    public RemoteRetryExecutor(RetryStrategy remoteRetryStrategies) {
        this.remoteRetryStrategies = remoteRetryStrategies;
    }
}

