/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.callback.future;

import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.client.core.client.RetryClient;
import com.aizuda.snailjob.client.core.context.RemoteRetryContext;
import com.aizuda.snailjob.client.model.DispatchRetryResultDTO;
import com.aizuda.snailjob.client.model.request.DispatchRetryResultRequest;
import com.aizuda.snailjob.common.core.enums.RetryResultStatusEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Objects;
import java.util.concurrent.CancellationException;

public class RetryTaskExecutorFutureCallback
implements FutureCallback<DispatchRetryResultDTO> {
    private static final RetryClient CLIENT = (RetryClient)RequestBuilder.newBuilder().client(RetryClient.class).callback(nettyResult -> {
        if (nettyResult.getStatus() == StatusEnum.NO.getStatus().intValue()) {
            SnailJobLog.LOCAL.error("Retry execute result report successfully requestId:[{}]", new Object[]{nettyResult.getReqId()});
        }
    }).build();
    private final RemoteRetryContext retryContext;

    public RetryTaskExecutorFutureCallback(RemoteRetryContext retryContext) {
        this.retryContext = retryContext;
    }

    public void onSuccess(DispatchRetryResultDTO result) {
        try {
            DispatchRetryResultRequest request = this.buildDispatchRetryResultRequest(result);
            if (RetryResultStatusEnum.SUCCESS.getStatus().equals(result.getStatusCode())) {
                request.setTaskStatus(RetryTaskStatusEnum.SUCCESS.getStatus());
            } else if (RetryResultStatusEnum.STOP.getStatus().equals(result.getStatusCode())) {
                request.setTaskStatus(RetryTaskStatusEnum.STOP.getStatus());
            } else {
                request.setTaskStatus(RetryTaskStatusEnum.FAIL.getStatus());
            }
            CLIENT.dispatchResult(request);
        }
        catch (Exception e) {
            SnailJobLog.REMOTE.error("\u6267\u884c\u7ed3\u679c\u4e0a\u62a5\u5f02\u5e38.[{}]", new Object[]{this.retryContext.getRetryTaskId(), e});
        }
    }

    public void onFailure(Throwable t) {
        if (t instanceof CancellationException) {
            SnailJobLog.LOCAL.debug("\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\uff0c\u4e0d\u505a\u72b6\u6001\u56de\u4f20", new Object[0]);
            return;
        }
        try {
            DispatchRetryResultRequest request = this.buildDispatchRetryResultRequest(null);
            request.setExceptionMsg(t.getMessage());
            request.setTaskStatus(RetryTaskStatusEnum.FAIL.getStatus());
            CLIENT.dispatchResult(request);
        }
        catch (Exception e) {
            SnailJobLog.REMOTE.error("\u6267\u884c\u7ed3\u679c\u4e0a\u62a5\u5f02\u5e38.[{}]", new Object[]{this.retryContext.getRetryTaskId(), e});
        }
    }

    private DispatchRetryResultRequest buildDispatchRetryResultRequest(DispatchRetryResultDTO result) {
        DispatchRetryResultRequest request = new DispatchRetryResultRequest();
        request.setRetryTaskId(this.retryContext.getRetryTaskId());
        request.setNamespaceId(this.retryContext.getNamespaceId());
        request.setGroupName(this.retryContext.getGroupName());
        request.setSceneName(this.retryContext.getScene());
        request.setRetryId(this.retryContext.getRetryId());
        request.setRetryTaskId(this.retryContext.getRetryTaskId());
        if (Objects.nonNull(result)) {
            request.setResult(result.getResultJson());
            request.setExceptionMsg(result.getExceptionMsg());
        }
        return request;
    }
}

