/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.report;

import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.client.NettyClient;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.client.core.report.AbstractReport;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.model.NettyResult;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.model.dto.ConfigDTO;
import com.aizuda.snailjob.server.model.dto.RetryTaskDTO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncReport
extends AbstractReport {
    private static final Logger log = LoggerFactory.getLogger(SyncReport.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static String reportErrorTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u540c\u6b65\u4e0a\u62a5\u5f02\u5e38</font>  \n> IP:{}  \n> \u7a7a\u95f4ID:{}  \n> \u540d\u79f0:{}  \n> \u65f6\u95f4:{}  \n> \u5f02\u5e38:{}  \n";
    @Autowired
    private SnailJobProperties snailJobProperties;

    @Override
    public boolean supports(boolean async) {
        return !async;
    }

    @Override
    public boolean doReport(RetryerInfo retryerInfo, Object[] params) {
        return this.syncReport(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params, retryerInfo.getTimeout(), retryerInfo.getUnit());
    }

    public Boolean syncReport(String scene, String targetClassName, Object[] args, long timeout, TimeUnit unit) {
        RetryTaskDTO retryTaskDTO = this.buildRetryTaskDTO(scene, targetClassName, args);
        NettyClient client = (NettyClient)RequestBuilder.newBuilder().client(NettyClient.class).async(Boolean.FALSE.booleanValue()).timeout(timeout).unit(unit).build();
        try {
            NettyResult result = client.reportRetryInfo(Collections.singletonList(retryTaskDTO));
            SnailJobLog.LOCAL.debug("Data report result result:[{}]", new Object[]{JsonUtil.toJsonString((Object)result)});
            return (Boolean)result.getData();
        }
        catch (Exception e) {
            this.sendMessage(e);
            throw e;
        }
    }

    private void sendMessage(Throwable e) {
        try {
            ConfigDTO.Notify notify = GroupVersionCache.getRetryNotifyAttribute((Integer)RetryNotifySceneEnum.CLIENT_REPORT_ERROR.getNotifyScene());
            if (Objects.isNull(notify)) {
                return;
            }
            List recipients = Optional.ofNullable(notify.getRecipients()).orElse(Lists.newArrayList());
            for (ConfigDTO.Notify.Recipient recipient : recipients) {
                AlarmContext context = AlarmContext.build().text(reportErrorTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), NetUtil.getLocalIpStr(), this.snailJobProperties.getNamespace(), this.snailJobProperties.getGroup(), LocalDateTime.now().format(formatter), e.getMessage()}).title("\u540c\u6b65\u4e0a\u62a5\u5f02\u5e38:[{}]", new Object[]{this.snailJobProperties.getGroup()}).notifyAttribute(recipient.getNotifyAttribute());
                Optional.ofNullable(SnailJobAlarmFactory.getAlarmType((Integer)recipient.getNotifyType())).ifPresent(alarm -> alarm.asyncSendMessage((Object)context));
            }
        }
        catch (Exception e1) {
            SnailJobLog.LOCAL.error("\u5ba2\u6237\u7aef\u53d1\u9001\u7ec4\u4ef6\u5f02\u5e38\u544a\u8b66\u5931\u8d25", new Object[]{e1});
        }
    }
}

