/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client.openapi;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.client.openapi.Request;
import com.aizuda.snailjob.client.common.rpc.client.openapi.SnailHttpClient;
import com.aizuda.snailjob.common.core.model.SnailJobOpenApiResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import java.text.MessageFormat;

public class DefaultHttpClient
implements SnailHttpClient {
    private static final String URL = "{0}://{1}:{2,number,#}/{3}/{4}";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private final SnailJobProperties.SnailOpenApiConfig config;

    public DefaultHttpClient(SnailJobProperties.SnailOpenApiConfig config) {
        this.config = config;
    }

    @Override
    public SnailJobOpenApiResult execute(Request request) {
        String prefix;
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((prefix = this.config.getPrefix()).startsWith("/")) {
            prefix = prefix.substring(1);
        }
        String host = this.config.getHost();
        Object url = MessageFormat.format(URL, this.config.isHttps() ? HTTPS : HTTP, host, this.config.getPort(), prefix, path);
        if (StrUtil.isNotBlank((CharSequence)request.getParams())) {
            url = (String)url + request.getParams();
        }
        HttpRequest httpRequest = HttpUtil.createRequest((Method)Method.valueOf((String)request.getMethod()), (String)url);
        httpRequest.body(request.getBody());
        httpRequest.addHeaders(request.getHeaders());
        return (SnailJobOpenApiResult)httpRequest.thenFunction(httpResponse -> (SnailJobOpenApiResult)JsonUtil.parseObject((String)httpResponse.body(), SnailJobOpenApiResult.class));
    }
}

