/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.log.report;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.LogReport;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.log.report.LogReportFactory;
import com.aizuda.snailjob.client.common.log.report.ReportLogListener;
import com.aizuda.snailjob.client.common.window.SlidingRingWindow;
import com.aizuda.snailjob.common.core.window.Listener;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.dto.LogContentDTO;
import com.aizuda.snailjob.model.request.LogTaskRequest;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLogReport<T extends LogTaskRequest>
implements Lifecycle,
InitializingBean,
LogReport {
    @Autowired
    private SnailJobProperties snailJobProperties;
    private SlidingRingWindow<LogTaskRequest> slidingWindow;

    @Override
    public void report(LogContentDTO logContentDTO) {
        this.slidingWindow.add((LogTaskRequest)this.buildLogTaskDTO(logContentDTO));
    }

    protected abstract T buildLogTaskDTO(LogContentDTO var1);

    @Override
    public void start() {
        if (Objects.nonNull(this.slidingWindow)) {
            return;
        }
        SnailJobProperties.LogSlidingWindowConfig logSlidingWindow = this.snailJobProperties.getLogSlidingWindow();
        ReportLogListener reportLogListener = new ReportLogListener();
        ChronoUnit chronoUnit = logSlidingWindow.getChronoUnit();
        Duration duration = Duration.of(logSlidingWindow.getDuration(), chronoUnit);
        this.slidingWindow = new SlidingRingWindow(duration, logSlidingWindow.getTotalThreshold(), Lists.newArrayList((Object[])new Listener[]{reportLogListener}));
    }

    @Override
    public void close() {
        if (Objects.isNull(this.slidingWindow)) {
            return;
        }
        SnailJobLog.LOCAL.info("AsyncReport Log about to shutdown", new Object[0]);
        this.slidingWindow.shutdown();
        SnailJobLog.LOCAL.info("AsyncReport Log has been shutdown", new Object[0]);
    }

    public void afterPropertiesSet() throws Exception {
        LogReportFactory.add(this);
    }
}

