/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.server;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.common.rpc.client.grpc.GrpcChannel;
import com.aizuda.snailjob.client.common.rpc.server.GrpcInterceptor;
import com.aizuda.snailjob.client.common.rpc.supports.handler.SnailDispatcherRequestHandler;
import com.aizuda.snailjob.client.common.rpc.supports.handler.grpc.UnaryRequestHandler;
import com.aizuda.snailjob.common.core.enums.RpcTypeEnum;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcResult;
import com.aizuda.snailjob.common.core.grpc.auto.SnailJobGrpcRequest;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.Message;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.util.MutableHandlerRegistry;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SnailGrpcServer
implements Lifecycle {
    private final SnailJobProperties snailJobProperties;
    private final SnailDispatcherRequestHandler snailDispatcherRequestHandler;
    private volatile boolean started = false;
    private Server server;

    @Override
    public void start() {
        if (this.started || RpcTypeEnum.GRPC != this.snailJobProperties.getRpcType()) {
            return;
        }
        SnailJobProperties.RpcServerProperties grpc = this.snailJobProperties.getServerRpc();
        MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
        this.addServices(handlerRegistry, new GrpcInterceptor());
        NettyServerBuilder builder = (NettyServerBuilder)NettyServerBuilder.forPort((int)GrpcChannel.getClientPort()).executor((Executor)this.createGrpcExecutor(grpc.getDispatcherTp()));
        Duration keepAliveTime = grpc.getKeepAliveTime();
        Duration keepAliveTimeOut = grpc.getKeepAliveTimeout();
        Duration permitKeepAliveTime = grpc.getPermitKeepAliveTime();
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)builder.maxInboundMessageSize(grpc.getMaxInboundMessageSize()).fallbackHandlerRegistry((HandlerRegistry)handlerRegistry)).compressorRegistry(CompressorRegistry.getDefaultInstance())).decompressorRegistry(DecompressorRegistry.getDefaultInstance())).keepAliveTime(keepAliveTime.toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(keepAliveTimeOut.toMillis(), TimeUnit.MILLISECONDS).permitKeepAliveTime(permitKeepAliveTime.toMillis(), TimeUnit.MILLISECONDS).build();
        try {
            this.server.start();
            this.started = true;
            SnailJobLog.LOCAL.info("------> snail-job remoting server start success, grpc = {}, port = {}", new Object[]{SnailGrpcServer.class.getName(), this.snailJobProperties.getPort()});
        }
        catch (IOException e) {
            SnailJobLog.LOCAL.error("--------> snail-job remoting server error.", new Object[]{e});
            this.started = false;
            throw new SnailJobClientException("snail-job server start error");
        }
    }

    @Override
    public void close() {
        if (this.server != null) {
            this.server.shutdownNow();
        }
    }

    private void addServices(MutableHandlerRegistry handlerRegistry, ServerInterceptor ... serverInterceptor) {
        ServerServiceDefinition serviceDefinition = SnailGrpcServer.createUnaryServiceDefinition("UnaryRequest", "unaryRequest", new UnaryRequestHandler(this.snailJobProperties.getServerRpc().getDispatcherTp(), this.snailDispatcherRequestHandler));
        handlerRegistry.addService(serviceDefinition);
        handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, (ServerInterceptor[])serverInterceptor));
    }

    public static ServerServiceDefinition createUnaryServiceDefinition(String serviceName, String methodName, ServerCalls.UnaryMethod<SnailJobGrpcRequest, GrpcResult> unaryMethod) {
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceName, (String)methodName)).setRequestMarshaller(ProtoUtils.marshaller((Message)SnailJobGrpcRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GrpcResult.getDefaultInstance())).build();
        return ServerServiceDefinition.builder((String)serviceName).addMethod(methodDescriptor, ServerCalls.asyncUnaryCall(unaryMethod)).build();
    }

    private ThreadPoolExecutor createGrpcExecutor(SnailJobProperties.ThreadPoolConfig threadPool) {
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(threadPool.getCorePoolSize(), threadPool.getMaximumPoolSize(), threadPool.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(threadPool.getQueueCapacity()), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("snail-job-grpc-server-executor-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }

    public SnailGrpcServer(SnailJobProperties snailJobProperties, SnailDispatcherRequestHandler snailDispatcherRequestHandler) {
        this.snailJobProperties = snailJobProperties;
        this.snailDispatcherRequestHandler = snailDispatcherRequestHandler;
    }

    public SnailJobProperties getSnailJobProperties() {
        return this.snailJobProperties;
    }

    public SnailDispatcherRequestHandler getSnailDispatcherRequestHandler() {
        return this.snailDispatcherRequestHandler;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Server getServer() {
        return this.server;
    }
}

