/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.config;

import com.aizuda.snailjob.common.core.alarm.email.SnailJobMailProperties;
import com.aizuda.snailjob.common.core.enums.RpcTypeEnum;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="snail-job")
public class SnailJobProperties {
    private String namespace;
    private String group;
    private String token;
    private String host;
    private Integer port = 17889;
    private RpcTypeEnum rpcType = RpcTypeEnum.GRPC;
    private LogSlidingWindowConfig logSlidingWindow = new LogSlidingWindowConfig();
    private ServerConfig server = new ServerConfig();
    private HttpResponse httpResponse;
    private Retry retry = new Retry();
    @NestedConfigurationProperty
    private SnailJobMailProperties mail = new SnailJobMailProperties();
    private String workspace;
    private RpcClientProperties clientRpc = new RpcClientProperties();
    private RpcServerProperties serverRpc = new RpcServerProperties();

    public String getNamespace() {
        return this.namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public String getToken() {
        return this.token;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public RpcTypeEnum getRpcType() {
        return this.rpcType;
    }

    public LogSlidingWindowConfig getLogSlidingWindow() {
        return this.logSlidingWindow;
    }

    public ServerConfig getServer() {
        return this.server;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public SnailJobMailProperties getMail() {
        return this.mail;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public RpcClientProperties getClientRpc() {
        return this.clientRpc;
    }

    public RpcServerProperties getServerRpc() {
        return this.serverRpc;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setRpcType(RpcTypeEnum rpcType) {
        this.rpcType = rpcType;
    }

    public void setLogSlidingWindow(LogSlidingWindowConfig logSlidingWindow) {
        this.logSlidingWindow = logSlidingWindow;
    }

    public void setServer(ServerConfig server) {
        this.server = server;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void setRetry(Retry retry) {
        this.retry = retry;
    }

    public void setMail(SnailJobMailProperties mail) {
        this.mail = mail;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void setClientRpc(RpcClientProperties clientRpc) {
        this.clientRpc = clientRpc;
    }

    public void setServerRpc(RpcServerProperties serverRpc) {
        this.serverRpc = serverRpc;
    }

    public static class ThreadPoolConfig {
        private int corePoolSize = 16;
        private int maximumPoolSize = 16;
        private long keepAliveTime = 1L;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private int queueCapacity = 10000;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public void setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadPoolConfig)) {
                return false;
            }
            ThreadPoolConfig other = (ThreadPoolConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCorePoolSize() != other.getCorePoolSize()) {
                return false;
            }
            if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
                return false;
            }
            if (this.getKeepAliveTime() != other.getKeepAliveTime()) {
                return false;
            }
            if (this.getQueueCapacity() != other.getQueueCapacity()) {
                return false;
            }
            TimeUnit this$timeUnit = this.getTimeUnit();
            TimeUnit other$timeUnit = other.getTimeUnit();
            return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadPoolConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCorePoolSize();
            result = result * 59 + this.getMaximumPoolSize();
            long $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + (int)($keepAliveTime >>> 32 ^ $keepAliveTime);
            result = result * 59 + this.getQueueCapacity();
            TimeUnit $timeUnit = this.getTimeUnit();
            result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.ThreadPoolConfig(corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", keepAliveTime=" + this.getKeepAliveTime() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", queueCapacity=" + this.getQueueCapacity() + ")";
        }

        public ThreadPoolConfig(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit, int queueCapacity) {
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
            this.timeUnit = timeUnit;
            this.queueCapacity = queueCapacity;
        }

        public ThreadPoolConfig() {
        }
    }

    public static class RpcClientProperties {
        private int maxInboundMessageSize = 0xA00000;
        private Duration keepAliveTime = Duration.of(2L, ChronoUnit.HOURS);
        private Duration keepAliveTimeout = Duration.of(20L, ChronoUnit.SECONDS);
        private Duration permitKeepAliveTime = Duration.of(5L, ChronoUnit.MINUTES);
        private ThreadPoolConfig clientTp = new ThreadPoolConfig(16, 16, 1L, TimeUnit.SECONDS, 10000);

        public int getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public Duration getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public Duration getPermitKeepAliveTime() {
            return this.permitKeepAliveTime;
        }

        public ThreadPoolConfig getClientTp() {
            return this.clientTp;
        }

        public void setMaxInboundMessageSize(int maxInboundMessageSize) {
            this.maxInboundMessageSize = maxInboundMessageSize;
        }

        public void setKeepAliveTime(Duration keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setKeepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
        }

        public void setPermitKeepAliveTime(Duration permitKeepAliveTime) {
            this.permitKeepAliveTime = permitKeepAliveTime;
        }

        public void setClientTp(ThreadPoolConfig clientTp) {
            this.clientTp = clientTp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RpcClientProperties)) {
                return false;
            }
            RpcClientProperties other = (RpcClientProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxInboundMessageSize() != other.getMaxInboundMessageSize()) {
                return false;
            }
            Duration this$keepAliveTime = this.getKeepAliveTime();
            Duration other$keepAliveTime = other.getKeepAliveTime();
            if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
                return false;
            }
            Duration this$keepAliveTimeout = this.getKeepAliveTimeout();
            Duration other$keepAliveTimeout = other.getKeepAliveTimeout();
            if (this$keepAliveTimeout == null ? other$keepAliveTimeout != null : !((Object)this$keepAliveTimeout).equals(other$keepAliveTimeout)) {
                return false;
            }
            Duration this$permitKeepAliveTime = this.getPermitKeepAliveTime();
            Duration other$permitKeepAliveTime = other.getPermitKeepAliveTime();
            if (this$permitKeepAliveTime == null ? other$permitKeepAliveTime != null : !((Object)this$permitKeepAliveTime).equals(other$permitKeepAliveTime)) {
                return false;
            }
            ThreadPoolConfig this$clientTp = this.getClientTp();
            ThreadPoolConfig other$clientTp = other.getClientTp();
            return !(this$clientTp == null ? other$clientTp != null : !((Object)this$clientTp).equals(other$clientTp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RpcClientProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxInboundMessageSize();
            Duration $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
            Duration $keepAliveTimeout = this.getKeepAliveTimeout();
            result = result * 59 + ($keepAliveTimeout == null ? 43 : ((Object)$keepAliveTimeout).hashCode());
            Duration $permitKeepAliveTime = this.getPermitKeepAliveTime();
            result = result * 59 + ($permitKeepAliveTime == null ? 43 : ((Object)$permitKeepAliveTime).hashCode());
            ThreadPoolConfig $clientTp = this.getClientTp();
            result = result * 59 + ($clientTp == null ? 43 : ((Object)$clientTp).hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.RpcClientProperties(maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", permitKeepAliveTime=" + this.getPermitKeepAliveTime() + ", clientTp=" + this.getClientTp() + ")";
        }
    }

    public static class RpcServerProperties {
        private int maxInboundMessageSize = 0xA00000;
        private Duration keepAliveTime = Duration.of(2L, ChronoUnit.HOURS);
        private Duration keepAliveTimeout = Duration.of(20L, ChronoUnit.SECONDS);
        private Duration permitKeepAliveTime = Duration.of(5L, ChronoUnit.MINUTES);
        private ThreadPoolConfig dispatcherTp = new ThreadPoolConfig(16, 16, 1L, TimeUnit.SECONDS, 10000);

        public int getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public Duration getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public Duration getPermitKeepAliveTime() {
            return this.permitKeepAliveTime;
        }

        public ThreadPoolConfig getDispatcherTp() {
            return this.dispatcherTp;
        }

        public void setMaxInboundMessageSize(int maxInboundMessageSize) {
            this.maxInboundMessageSize = maxInboundMessageSize;
        }

        public void setKeepAliveTime(Duration keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setKeepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
        }

        public void setPermitKeepAliveTime(Duration permitKeepAliveTime) {
            this.permitKeepAliveTime = permitKeepAliveTime;
        }

        public void setDispatcherTp(ThreadPoolConfig dispatcherTp) {
            this.dispatcherTp = dispatcherTp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RpcServerProperties)) {
                return false;
            }
            RpcServerProperties other = (RpcServerProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxInboundMessageSize() != other.getMaxInboundMessageSize()) {
                return false;
            }
            Duration this$keepAliveTime = this.getKeepAliveTime();
            Duration other$keepAliveTime = other.getKeepAliveTime();
            if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
                return false;
            }
            Duration this$keepAliveTimeout = this.getKeepAliveTimeout();
            Duration other$keepAliveTimeout = other.getKeepAliveTimeout();
            if (this$keepAliveTimeout == null ? other$keepAliveTimeout != null : !((Object)this$keepAliveTimeout).equals(other$keepAliveTimeout)) {
                return false;
            }
            Duration this$permitKeepAliveTime = this.getPermitKeepAliveTime();
            Duration other$permitKeepAliveTime = other.getPermitKeepAliveTime();
            if (this$permitKeepAliveTime == null ? other$permitKeepAliveTime != null : !((Object)this$permitKeepAliveTime).equals(other$permitKeepAliveTime)) {
                return false;
            }
            ThreadPoolConfig this$dispatcherTp = this.getDispatcherTp();
            ThreadPoolConfig other$dispatcherTp = other.getDispatcherTp();
            return !(this$dispatcherTp == null ? other$dispatcherTp != null : !((Object)this$dispatcherTp).equals(other$dispatcherTp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RpcServerProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxInboundMessageSize();
            Duration $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
            Duration $keepAliveTimeout = this.getKeepAliveTimeout();
            result = result * 59 + ($keepAliveTimeout == null ? 43 : ((Object)$keepAliveTimeout).hashCode());
            Duration $permitKeepAliveTime = this.getPermitKeepAliveTime();
            result = result * 59 + ($permitKeepAliveTime == null ? 43 : ((Object)$permitKeepAliveTime).hashCode());
            ThreadPoolConfig $dispatcherTp = this.getDispatcherTp();
            result = result * 59 + ($dispatcherTp == null ? 43 : ((Object)$dispatcherTp).hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.RpcServerProperties(maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", permitKeepAliveTime=" + this.getPermitKeepAliveTime() + ", dispatcherTp=" + this.getDispatcherTp() + ")";
        }
    }

    public static class Retry {
        private SlidingWindowConfig reportSlidingWindow = new SlidingWindowConfig();
        private ThreadPoolConfig dispatcherThreadPool = new ThreadPoolConfig(32, 32, 1L, TimeUnit.SECONDS, 10000);

        public SlidingWindowConfig getReportSlidingWindow() {
            return this.reportSlidingWindow;
        }

        public ThreadPoolConfig getDispatcherThreadPool() {
            return this.dispatcherThreadPool;
        }

        public void setReportSlidingWindow(SlidingWindowConfig reportSlidingWindow) {
            this.reportSlidingWindow = reportSlidingWindow;
        }

        public void setDispatcherThreadPool(ThreadPoolConfig dispatcherThreadPool) {
            this.dispatcherThreadPool = dispatcherThreadPool;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Retry)) {
                return false;
            }
            Retry other = (Retry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SlidingWindowConfig this$reportSlidingWindow = this.getReportSlidingWindow();
            SlidingWindowConfig other$reportSlidingWindow = other.getReportSlidingWindow();
            if (this$reportSlidingWindow == null ? other$reportSlidingWindow != null : !((Object)this$reportSlidingWindow).equals(other$reportSlidingWindow)) {
                return false;
            }
            ThreadPoolConfig this$dispatcherThreadPool = this.getDispatcherThreadPool();
            ThreadPoolConfig other$dispatcherThreadPool = other.getDispatcherThreadPool();
            return !(this$dispatcherThreadPool == null ? other$dispatcherThreadPool != null : !((Object)this$dispatcherThreadPool).equals(other$dispatcherThreadPool));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Retry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SlidingWindowConfig $reportSlidingWindow = this.getReportSlidingWindow();
            result = result * 59 + ($reportSlidingWindow == null ? 43 : ((Object)$reportSlidingWindow).hashCode());
            ThreadPoolConfig $dispatcherThreadPool = this.getDispatcherThreadPool();
            result = result * 59 + ($dispatcherThreadPool == null ? 43 : ((Object)$dispatcherThreadPool).hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.Retry(reportSlidingWindow=" + this.getReportSlidingWindow() + ", dispatcherThreadPool=" + this.getDispatcherThreadPool() + ")";
        }
    }

    public static class LogSlidingWindowConfig {
        private int totalThreshold = 50;
        private int windowTotalThreshold = 150;
        private long duration = 5L;
        private ChronoUnit chronoUnit = ChronoUnit.SECONDS;

        public int getTotalThreshold() {
            return this.totalThreshold;
        }

        public int getWindowTotalThreshold() {
            return this.windowTotalThreshold;
        }

        public long getDuration() {
            return this.duration;
        }

        public ChronoUnit getChronoUnit() {
            return this.chronoUnit;
        }

        public void setTotalThreshold(int totalThreshold) {
            this.totalThreshold = totalThreshold;
        }

        public void setWindowTotalThreshold(int windowTotalThreshold) {
            this.windowTotalThreshold = windowTotalThreshold;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void setChronoUnit(ChronoUnit chronoUnit) {
            this.chronoUnit = chronoUnit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogSlidingWindowConfig)) {
                return false;
            }
            LogSlidingWindowConfig other = (LogSlidingWindowConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalThreshold() != other.getTotalThreshold()) {
                return false;
            }
            if (this.getWindowTotalThreshold() != other.getWindowTotalThreshold()) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            ChronoUnit this$chronoUnit = this.getChronoUnit();
            ChronoUnit other$chronoUnit = other.getChronoUnit();
            return !(this$chronoUnit == null ? other$chronoUnit != null : !this$chronoUnit.equals(other$chronoUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LogSlidingWindowConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTotalThreshold();
            result = result * 59 + this.getWindowTotalThreshold();
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            ChronoUnit $chronoUnit = this.getChronoUnit();
            result = result * 59 + ($chronoUnit == null ? 43 : $chronoUnit.hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.LogSlidingWindowConfig(totalThreshold=" + this.getTotalThreshold() + ", windowTotalThreshold=" + this.getWindowTotalThreshold() + ", duration=" + this.getDuration() + ", chronoUnit=" + this.getChronoUnit() + ")";
        }
    }

    public static class SlidingWindowConfig {
        private int totalThreshold = 50;
        private int windowTotalThreshold = 150;
        private long duration = 10L;
        private ChronoUnit chronoUnit = ChronoUnit.SECONDS;

        public int getTotalThreshold() {
            return this.totalThreshold;
        }

        public int getWindowTotalThreshold() {
            return this.windowTotalThreshold;
        }

        public long getDuration() {
            return this.duration;
        }

        public ChronoUnit getChronoUnit() {
            return this.chronoUnit;
        }

        public void setTotalThreshold(int totalThreshold) {
            this.totalThreshold = totalThreshold;
        }

        public void setWindowTotalThreshold(int windowTotalThreshold) {
            this.windowTotalThreshold = windowTotalThreshold;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void setChronoUnit(ChronoUnit chronoUnit) {
            this.chronoUnit = chronoUnit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlidingWindowConfig)) {
                return false;
            }
            SlidingWindowConfig other = (SlidingWindowConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalThreshold() != other.getTotalThreshold()) {
                return false;
            }
            if (this.getWindowTotalThreshold() != other.getWindowTotalThreshold()) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            ChronoUnit this$chronoUnit = this.getChronoUnit();
            ChronoUnit other$chronoUnit = other.getChronoUnit();
            return !(this$chronoUnit == null ? other$chronoUnit != null : !this$chronoUnit.equals(other$chronoUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SlidingWindowConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTotalThreshold();
            result = result * 59 + this.getWindowTotalThreshold();
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            ChronoUnit $chronoUnit = this.getChronoUnit();
            result = result * 59 + ($chronoUnit == null ? 43 : $chronoUnit.hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.SlidingWindowConfig(totalThreshold=" + this.getTotalThreshold() + ", windowTotalThreshold=" + this.getWindowTotalThreshold() + ", duration=" + this.getDuration() + ", chronoUnit=" + this.getChronoUnit() + ")";
        }
    }

    public static class HttpResponse {
        private Integer code = 200;
        private String field = "code";
        private String responseType = "json";

        public Integer getCode() {
            return this.code;
        }

        public String getField() {
            return this.field;
        }

        public String getResponseType() {
            return this.responseType;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpResponse)) {
                return false;
            }
            HttpResponse other = (HttpResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$responseType = this.getResponseType();
            String other$responseType = other.getResponseType();
            return !(this$responseType == null ? other$responseType != null : !this$responseType.equals(other$responseType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $responseType = this.getResponseType();
            result = result * 59 + ($responseType == null ? 43 : $responseType.hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.HttpResponse(code=" + this.getCode() + ", field=" + this.getField() + ", responseType=" + this.getResponseType() + ")";
        }
    }

    public static class ServerConfig {
        private String host = "127.0.0.1";
        private int port = 17888;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerConfig)) {
                return false;
            }
            ServerConfig other = (ServerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServerConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.ServerConfig(host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }
    }
}

