/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client;

import com.aizuda.snailjob.client.common.event.SnailChannelReconnectEvent;
import com.aizuda.snailjob.client.common.handler.ClientRegister;
import com.aizuda.snailjob.client.common.rpc.client.NettyHttpConnectClient;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.rpc.RpcContext;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class NettyHttpClientHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(NettyHttpClientHandler.class);
    private final NettyHttpConnectClient nettyHttpConnectClient;

    public NettyHttpClientHandler(NettyHttpConnectClient nettyHttpConnectClient) {
        this.nettyHttpConnectClient = nettyHttpConnectClient;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        FullHttpResponse response = msg;
        String content = response.content().toString(CharsetUtil.UTF_8);
        HttpHeaders headers = response.headers();
        SnailJobLog.LOCAL.debug("Receive server data content:[{}], headers:[{}]", new Object[]{content, headers});
        SnailJobRpcResult snailJobRpcResult = (SnailJobRpcResult)JsonUtil.parseObject((String)content, SnailJobRpcResult.class);
        RpcContext.invoke((Long)snailJobRpcResult.getReqId(), (SnailJobRpcResult)snailJobRpcResult, (boolean)false);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        SnailJobLog.LOCAL.debug("channelRegistered", new Object[0]);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        SnailJobLog.LOCAL.debug("channelUnregistered", new Object[0]);
        ctx.channel().eventLoop().schedule(() -> {
            try {
                SnailSpringContext.getContext().publishEvent((ApplicationEvent)new SnailChannelReconnectEvent());
                this.nettyHttpConnectClient.reconnect();
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("reconnect error ", new Object[]{e});
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        SnailJobLog.LOCAL.debug("channelActive", new Object[0]);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        SnailJobLog.LOCAL.debug("channelInactive", new Object[0]);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        SnailJobLog.LOCAL.debug("channelReadComplete", new Object[0]);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        SnailJobLog.LOCAL.debug("channelWritabilityChanged", new Object[0]);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        SnailJobLog.LOCAL.error("snail-job netty-http client exception", new Object[]{cause});
        super.exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        SnailJobLog.LOCAL.debug("userEventTriggered", new Object[0]);
        if (evt instanceof IdleStateEvent) {
            ClientRegister.CLIENT.beat("PING");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

