/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.client.common.annotation.Mapping;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.common.exception.SnailJobClientTimeOutException;
import com.aizuda.snailjob.client.common.rpc.client.NettyChannel;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.rpc.RpcContext;
import com.aizuda.snailjob.common.core.rpc.SnailJobFuture;
import com.aizuda.snailjob.common.log.SnailJobLog;
import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class RpcClientInvokeHandler<R extends Result<Object>>
implements InvocationHandler {
    private final Consumer<R> consumer;
    private final boolean async;
    private final long timeout;
    private final TimeUnit unit;

    public RpcClientInvokeHandler(boolean async, long timeout, TimeUnit unit, Consumer<R> consumer) {
        this.consumer = consumer;
        this.async = async;
        this.timeout = timeout;
        this.unit = unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StopWatch sw = new StopWatch();
        Mapping annotation = method.getAnnotation(Mapping.class);
        SnailJobRequest snailJobRequest = new SnailJobRequest(args);
        sw.start("request start " + snailJobRequest.getReqId());
        SnailJobFuture newFuture = SnailJobFuture.newFuture((Long)snailJobRequest.getReqId(), (long)this.timeout, (TimeUnit)this.unit);
        RpcContext.setFuture((SnailJobFuture)newFuture);
        try {
            NettyChannel.send(HttpMethod.valueOf((String)annotation.method().name()), annotation.path(), snailJobRequest.toString());
        }
        finally {
            sw.stop();
        }
        SnailJobLog.LOCAL.debug("request complete requestId:[{}] \u8017\u65f6:[{}ms]", new Object[]{snailJobRequest.getReqId(), sw.getTotalTimeMillis()});
        if (this.async) {
            newFuture.whenComplete((r, t) -> {
                if (Objects.nonNull(t)) {
                    this.consumer.accept(new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), t.getMessage(), null, snailJobRequest.getReqId()));
                } else {
                    this.consumer.accept(r);
                }
            });
            return null;
        }
        Assert.notNull((Object)newFuture, () -> new SnailJobClientException("completableFuture is null"));
        try {
            return (R)((Result)newFuture.get(Integer.MAX_VALUE, TimeUnit.MILLISECONDS));
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        catch (TimeoutException e) {
            throw new SnailJobClientTimeOutException("Request to remote interface timed out. path:[{}]", (Object)annotation.path());
        }
    }
}

