/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.handler;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.NettyClient;
import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.model.dto.ConfigDTO;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class SyncRemoteConfig
implements Lifecycle {
    private static final NettyClient CLIENT;
    private static final ScheduledExecutorService SCHEDULE_EXECUTOR;

    @Override
    public void start() {
        SCHEDULE_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                CLIENT.syncRemoteConfig();
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u901a\u77e5\u914d\u7f6e\u5931\u8d25", new Object[]{e});
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void close() {
    }

    static {
        SCHEDULE_EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "sync-remote-config"));
        CLIENT = RequestBuilder.newBuilder().client(NettyClient.class).timeout(1000L).callback(nettyResult -> {
            if (Objects.isNull(nettyResult.getData())) {
                SnailJobLog.LOCAL.debug("\u83b7\u53d6\u914d\u7f6e\u7ed3\u679c\u4e3anull", new Object[0]);
                return;
            }
            GroupVersionCache.setConfig((ConfigDTO)JsonUtil.parseObject((String)nettyResult.getData().toString(), ConfigDTO.class));
        }).build();
    }
}

