/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.log.support;

import cn.hutool.core.util.ServiceLoaderUtil;
import com.aizuda.snailjob.client.common.SnailLogContext;
import com.aizuda.snailjob.client.common.log.context.ThreadLocalLogContext;
import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import java.util.Optional;

public final class SnailJobLogManager {
    private static final SnailLogContext<LogTypeEnum> LOG_TYPE = SnailJobLogManager.snailJobLogContextLoader();
    private static final SnailLogContext<LogMeta> LOG_META = SnailJobLogManager.snailJobLogContextLoader();

    private static <T> SnailLogContext<T> snailJobLogContextLoader() {
        return Optional.ofNullable((SnailLogContext)ServiceLoaderUtil.loadFirst(SnailLogContext.class)).orElse(new ThreadLocalLogContext(new ThreadLocal()));
    }

    private SnailJobLogManager() {
    }

    public static void initLogInfo(LogMeta logMeta, LogTypeEnum logType) {
        SnailJobLogManager.setLogMeta(logMeta);
        SnailJobLogManager.setLogType(logType);
    }

    public static void setLogMeta(LogMeta logMeta) {
        LOG_META.set(logMeta);
    }

    public static LogMeta getLogMeta() {
        return LOG_META.get();
    }

    public static void removeLogMeta() {
        LOG_META.remove();
    }

    public static void removeAll() {
        SnailJobLogManager.removeLogMeta();
        SnailJobLogManager.removeLogType();
    }

    public static void setLogType(LogTypeEnum logType) {
        LOG_TYPE.set(logType);
    }

    public static LogTypeEnum getLogType() {
        return LOG_TYPE.get();
    }

    public static void removeLogType() {
        LOG_TYPE.remove();
    }
}

