/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log.action;

import android.os.Environment;
import com.aiven.log.LogConfig;
import com.aiven.log.action.LogCheckListListener;
import com.aiven.log.model.LogMode;
import com.aiven.log.util.LogPrintWriter;
import com.aiven.log.util.LogTimeUtils;
import java.io.File;
import java.io.FileOutputStream;

public class LogWriteUtils
extends Thread {
    private LogPrintWriter mOs;
    private LogCheckListListener listener;

    public LogWriteUtils(LogCheckListListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        try {
            while (true) {
                LogMode mode = this.listener.backNextLog();
                this.writeLog(mode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeLog(LogMode mode) {
        if (mode == null) {
            return;
        }
        try {
            this.initOs(mode);
            if (this.mOs != null) {
                this.mOs.println(mode.getTime() + "  " + mode.getTag() + "  " + mode.getMsg());
                this.mOs.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mOs = null;
        }
        finally {
            mode = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOs(LogMode mode) {
        String filePath = mode.isCrashInfo() ? LogConfig.getLogSavePath() + "crash" + File.separator + LogTimeUtils.getInstance().getData() + ".txt" : LogConfig.getLogSavePath() + LogTimeUtils.getInstance().getData() + ".txt";
        File f = new File(filePath);
        if (this.checkFile(f) && this.mOs != null) {
            if (this.mOs.isCrashWriter() && mode.isCrashInfo() || !this.mOs.isCrashWriter() && !mode.isCrashInfo()) {
                return;
            }
            try {
                this.mOs.close();
            }
            catch (Exception e) {
            }
            finally {
                this.mOs = null;
            }
        }
        if (Environment.getExternalStorageState().equals("mounted")) {
            try {
                if (!f.exists()) {
                    try {
                        f.getParentFile().mkdirs();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    f.createNewFile();
                }
                this.mOs = new LogPrintWriter(new FileOutputStream(f, true));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mOs = null;
            }
            finally {
                f = null;
            }
        } else {
            this.mOs = null;
            f = null;
        }
    }

    private boolean checkFile(File f) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            try {
                return f.exists();
            }
            catch (Exception e) {
                return false;
            }
        }
        f = null;
        return false;
    }

    public void startEngine() {
        this.start();
    }
}

