package com.aitime.android.security;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 * Tools for AES encryption and decryption
 */
public final class AES {

    private static final String ALGORITHM_NAME = "AES";
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";

    private AES() {
        throw new UnsupportedOperationException("Instantiation operation is not supported.");
    }

    /**
     * Encryption
     *
     * @param secretKey Key for encryption, consisting of 16-bit characters
     * @param vector    vector offset
     * @param content   content to be encrypted
     * @return
     * @throws Exception
     */
    public static byte[] encrypt(String secretKey, String vector, byte[] content) throws Exception {
        return encrypt(secretKey, vector, TRANSFORMATION, content);
    }

    /**
     * Encryption
     *
     * @param secretKey Key for encryption, consisting of 16-bit characters
     * @param vector    vector
     * @param content   content to be encrypted
     * @return
     * @throws Exception
     */
    public static byte[] encrypt(String secretKey, String vector, String transformation, byte[] content) throws Exception {
        SecretKeySpec skeySpec = generateAESKey(secretKey);// 获得密钥
        Cipher cipher = Cipher.getInstance(transformation);// 私钥加密对象Cipher
        if (vector == null || vector.isEmpty()) {
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec);// 设置工作模式为加密模式，给出密钥
        } else {
            IvParameterSpec iv = new IvParameterSpec(vector.getBytes());// 使用CBC模式，需要一个向量iv，可增加加密算法的强度
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);// 设置工作模式为解密模式，给出密钥
        }
        return cipher.doFinal(content);// 执行加密操作
    }

    /**
     * Decryption
     *
     * @param secretKey Key for decryption, consisting of 16-bit characters
     * @param vector    vector
     * @param content   content to be decrypted
     * @return
     * @throws Exception
     */
    public static byte[] decrypt(String secretKey, String vector, byte[] content) throws Exception {
        return decrypt(secretKey, vector, TRANSFORMATION, content);
    }

    /**
     * Decryption
     *
     * @param secretKey Key for decryption, consisting of 16-bit characters
     * @param vector    vector
     * @param content   content to be decrypted
     * @return
     * @throws Exception
     */
    public static byte[] decrypt(String secretKey, String vector, String transformation, byte[] content) throws Exception {
        SecretKeySpec skeySpec = generateAESKey(secretKey);// 获得密钥
        Cipher cipher = Cipher.getInstance(transformation);// 私钥加密对象Cipher
        if (vector == null || vector.isEmpty()) {
            cipher.init(Cipher.DECRYPT_MODE, skeySpec);// 设置工作模式为解密模式，给出密钥
        } else {
            IvParameterSpec iv = new IvParameterSpec(vector.getBytes());// 使用CBC模式，需要一个向量iv，可增加加密算法的强度
            cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);// 设置工作模式为解密模式，给出密钥
        }
        return cipher.doFinal(content);// 执行解密操作
    }

    /**
     * Generate secret key
     *
     * @param password key consisting of 16 characters
     */
    private static SecretKeySpec generateAESKey(String password) {
        StringBuilder sb = new StringBuilder(password);
        while (sb.length() < 16) {
            sb.append("0");
        }
        if (sb.length() > 16) {
            sb.setLength(16);
        }
        String secretKey = sb.toString();
        byte[] raw = secretKey.getBytes();
        return new SecretKeySpec(raw, ALGORITHM_NAME);// 获得密钥
    }

}
