/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.aitime.android.payment.payumoney.R;
import com.payumoney.core.PayUmoneySdkInitializer;
import com.payumoney.sdkui.ui.utils.PayUmoneyFlowManager;
import java.lang.ref.WeakReference;
import java.util.Map;

@Payment(channel="payumoney")
public class PayUmoney
implements IPayment {
    private final WeakReference<Activity> mActivity;

    public PayUmoney(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public void callback(@NonNull IPaymentCallback callback) {
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        String name = this.getParameter(params, "name");
        String orderId = this.getParameter(params, "orderId");
        String merchantId = this.getParameter(params, "merchantId");
        String merchantKey = this.getParameter(params, "merchantKey");
        String hash = this.getParameter(params, "hash");
        String isDebug = this.getParameter(params, "isDebug");
        String surl = this.getParameter(params, "surl");
        String furl = this.getParameter(params, "furl");
        try {
            String payName = info.getPayName();
            PayUmoneySdkInitializer.PaymentParam paymentParam = new PayUmoneySdkInitializer.PaymentParam.Builder().setAmount(info.getPayMoney()).setTxnId(orderId).setPhone(info.getContact()).setFirstName(name).setEmail(info.getEmail()).setProductName(payName != null ? payName : "repayment").setsUrl(surl).setfUrl(furl).setIsDebug(Boolean.parseBoolean(isDebug)).setKey(merchantKey).setMerchantId(merchantId).build();
            paymentParam.setMerchantHash(hash);
            PayUmoneyFlowManager.startPayUMoneyFlow((PayUmoneySdkInitializer.PaymentParam)paymentParam, (Activity)activity, (int)R.style.AppTheme_default, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showToast(activity, e.getMessage());
        }
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return false;
        }
        String payuResponse = bundle.getString("payuResponse");
        String transactionStatus = bundle.getString("transactionStatus");
        if (payuResponse != null) {
            if ("SUCCESSFUL".equals(transactionStatus)) {
                return true;
            }
            if ("CANCELLED".equals(transactionStatus)) {
                this.showToast(activity, activity.getString(R.string.payment_status_cancelled));
                return false;
            }
            if ("FAILED".equals(transactionStatus)) {
                this.showToast(activity, activity.getString(R.string.payment_status_failed));
                return false;
            }
        }
        return false;
    }

    public void release() {
        Application application = ((Activity)this.mActivity.get()).getApplication();
        if (PayUmoneyFlowManager.isUserLoggedIn((Context)application)) {
            PayUmoneyFlowManager.logoutUser((Context)application);
        }
    }

    private void showToast(Activity activity, String text) {
        Toast.makeText((Context)activity, (CharSequence)text, (int)0).show();
    }
}

