package com.aitime.android.payment;

import android.content.Intent;
import android.os.Bundle;

import com.payumoney.core.entity.TransactionResponse;
import com.payumoney.core.response.PayumoneyError;
import com.payumoney.sdkui.ui.utils.PayUmoneyFlowManager;
import com.payumoney.sdkui.ui.utils.ResultModel;

/**
 * PayUmoney Result
 */
public final class PayUmoneyResult {

    public static Bundle create(Intent data) {
        ResultModel resultModel = data.getParcelableExtra(PayUmoneyFlowManager.ARG_RESULT);
        TransactionResponse transactionResponse = data.getParcelableExtra(PayUmoneyFlowManager.INTENT_EXTRA_TRANSACTION_RESPONSE);
        Bundle bundle = new Bundle();
        if (transactionResponse != null) {
            bundle.putString("payuResponse", transactionResponse.getPayuResponse());
            bundle.putString("transactionStatus", transactionResponse.getTransactionStatus().name());
            bundle.putString("transactionDetails", transactionResponse.getTransactionDetails());
        }
        if (resultModel != null && resultModel.getError() != null) {
            PayumoneyError error = resultModel.getError();
            com.payumoney.core.response.TransactionResponse response = error.getTransactionResponse();
            if (response != null) {
                bundle.putString("errorResponse", response.getJsonResponse());
            }
            bundle.putInt("statusCode", error.getStatusCode());
        }
        return bundle;
    }

}
