/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.aitime.android.payment.payumoney.R;
import com.payumoney.core.PayUmoneySdkInitializer;
import com.payumoney.sdkui.ui.utils.PayUmoneyFlowManager;
import java.util.Map;

@Payment(channel="payumoney")
public class PayUmoney
implements IPayment {
    private final Activity mActivity;

    public PayUmoney(Activity activity) {
        this.mActivity = activity;
    }

    public void callback(@NonNull IPaymentCallback callback) {
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        String merchantId = this.getParameter(params, "merchantId");
        String merchantKey = this.getParameter(params, "merchantKey");
        String hash = this.getParameter(params, "hash");
        String isDebug = this.getParameter(params, "isDebug");
        String surl = this.getParameter(params, "surl");
        String furl = this.getParameter(params, "furl");
        int labelRes = 0;
        try {
            Context context = this.mActivity.getApplicationContext();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            labelRes = packageInfo.applicationInfo.labelRes;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String payName = info.getPayName();
            PayUmoneySdkInitializer.PaymentParam paymentParam = new PayUmoneySdkInitializer.PaymentParam.Builder().setAmount(info.getPayMoney()).setTxnId(info.getOrderId()).setPhone(info.getContact()).setFirstName(info.getName()).setEmail(info.getEmail()).setProductName(payName != null ? payName : this.mActivity.getString(labelRes)).setsUrl(surl).setfUrl(furl).setIsDebug(Boolean.parseBoolean(isDebug)).setKey(merchantKey).setMerchantId(merchantId).build();
            paymentParam.setMerchantHash(hash);
            PayUmoneyFlowManager.startPayUMoneyFlow((PayUmoneySdkInitializer.PaymentParam)paymentParam, (Activity)this.mActivity, (int)R.style.AppTheme_default, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        String payuResponse = bundle.getString("payuResponse");
        String transactionStatus = bundle.getString("transactionStatus");
        if (payuResponse != null) {
            if ("SUCCESSFUL".equals(transactionStatus)) {
                return true;
            }
            if ("CANCELLED".equals(transactionStatus)) {
                this.showToast(R.string.payment_status_cancelled);
                return false;
            }
            if ("FAILED".equals(transactionStatus)) {
                this.showToast(R.string.payment_status_failed);
                return false;
            }
        }
        return false;
    }

    public void release() {
        Application application = this.mActivity.getApplication();
        if (PayUmoneyFlowManager.isUserLoggedIn((Context)application)) {
            PayUmoneyFlowManager.logoutUser((Context)application);
        }
    }

    private void showToast(@StringRes int resId) {
        Toast.makeText((Context)this.mActivity, (int)resId, (int)0).show();
    }
}

