/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.aitime.android.payment.payumobile.R;
import com.payu.base.models.ErrorResponse;
import com.payu.base.models.PayUPaymentParams;
import com.payu.checkoutpro.PayUCheckoutPro;
import com.payu.ui.model.listeners.PayUCheckoutProListener;
import com.payu.ui.model.listeners.PayUHashGenerationListener;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

@Payment(channel="payumobile")
public class PayUmobile
implements IPayment {
    private final WeakReference<Activity> mActivity;
    private IPaymentCallback mCallback;

    public PayUmobile(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public void callback(@NonNull IPaymentCallback callback) {
        this.mCallback = callback;
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        String name = this.getParameter(params, "name");
        String amount = this.getParameter(params, "amount");
        String product = this.getParameter(params, "product");
        String orderId = this.getParameter(params, "orderId");
        String merchantKey = this.getParameter(params, "merchantKey");
        String hash = this.getParameter(params, "hash");
        String isDebug = this.getParameter(params, "isDebug");
        String surl = this.getParameter(params, "surl");
        String furl = this.getParameter(params, "furl");
        final String salt = this.getParameter(params, "salt");
        String userCredentials = this.getParameter(params, "userCredentials");
        PayUPaymentParams payUPaymentParams = new PayUPaymentParams.Builder().setAmount(amount).setIsProduction(!Boolean.parseBoolean(isDebug)).setProductInfo(product).setKey(merchantKey).setPhone(info.getContact()).setTransactionId(orderId).setFirstName(name).setEmail(info.getEmail()).setSurl(surl).setFurl(furl).setUserCredential(userCredentials).build();
        PayUCheckoutPro.open((Activity)activity, (PayUPaymentParams)payUPaymentParams, (PayUCheckoutProListener)new PayUCheckoutProListener(){

            public void onPaymentSuccess(@NonNull Object response) {
                Bundle bundle = new Bundle();
                if (response instanceof HashMap) {
                    HashMap result = (HashMap)response;
                    String payuResponse = (String)result.get("payuResponse");
                    String merchantResponse = (String)result.get("merchantResponse");
                    bundle.putString("payuResponse", payuResponse);
                    bundle.putString("merchantResponse", merchantResponse);
                }
                PayUmobile.this.mCallback.onPaymentResult("1", bundle);
            }

            public void onPaymentFailure(@NonNull Object response) {
                Bundle bundle = new Bundle();
                if (response instanceof HashMap) {
                    HashMap result = (HashMap)response;
                    String payuResponse = (String)result.get("payuResponse");
                    String merchantResponse = (String)result.get("merchantResponse");
                    bundle.putString("payuResponse", payuResponse);
                    bundle.putString("merchantResponse", merchantResponse);
                }
                PayUmobile.this.mCallback.onPaymentResult("0", bundle);
            }

            public void onPaymentCancel(boolean isTxnInitiated) {
                Bundle bundle = new Bundle();
                bundle.putBoolean("isTxnInitiated", isTxnInitiated);
                PayUmobile.this.mCallback.onPaymentResult("-1", bundle);
            }

            public void onError(@NonNull ErrorResponse errorResponse) {
                Bundle bundle = new Bundle();
                bundle.putInt("errorCode", errorResponse.getErrorCode().intValue());
                bundle.putString("errorMessage", errorResponse.getErrorMessage());
                PayUmobile.this.mCallback.onPaymentResult("-2", bundle);
            }

            public void setWebViewProperties(@Nullable WebView webView, @Nullable Object o) {
            }

            public void generateHash(@NonNull HashMap<String, String> valueMap, @NonNull PayUHashGenerationListener hashGenerationListener) {
                String hashName = valueMap.get("hashName");
                String hashData = valueMap.get("hashString");
                if (!TextUtils.isEmpty((CharSequence)hashName) && !TextUtils.isEmpty((CharSequence)hashData)) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    dataMap.put(hashName, PayUmobile.this.calculateHash(hashData, salt));
                    hashGenerationListener.onHashGenerated(dataMap);
                }
            }
        });
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return false;
        }
        if ("1".equals(status)) {
            return true;
        }
        if ("-1".equals(status)) {
            this.showToast(activity, activity.getString(R.string.payment_status_cancelled));
        } else if ("-2".equals(status)) {
            int errorCode = bundle.getInt("errorCode");
            String errorMessage = bundle.getString("errorMessage");
            this.showToast(activity, activity.getString(R.string.payment_status_failed) + "[" + errorCode + "]" + errorMessage);
        } else {
            this.showToast(activity, activity.getString(R.string.payment_status_failed));
        }
        return false;
    }

    public void release() {
    }

    private String calculateHash(String paymentParams, String salt) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.update((paymentParams + salt).getBytes());
            byte[] digest = messageDigest.digest();
            return this.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String toHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            builder.append(hex);
        }
        return builder.toString();
    }

    private void showToast(Activity activity, String text) {
        Toast.makeText((Context)activity, (CharSequence)text, (int)0).show();
    }
}

