/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.aitime.android.payment.payumobile.R;
import com.payu.upisdk.Upi;
import com.payu.upisdk.bean.UpiConfig;
import com.payu.upisdk.callbacks.PayUUPICallback;
import com.payu.upisdk.generatepostdata.PaymentParamsUpiSdk;
import com.payu.upisdk.generatepostdata.PostDataGenerate;
import com.payu.upisdk.upi.IValidityCheck;
import java.lang.ref.WeakReference;
import java.util.Map;

@Payment(channel="payumobile")
public class PayUmobile
implements IPayment {
    private final WeakReference<Activity> mActivity;
    private IPaymentCallback mCallback;

    public PayUmobile(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public void callback(@NonNull IPaymentCallback callback) {
        this.mCallback = callback;
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        String name = this.getParameter(params, "name");
        String product = this.getParameter(params, "product");
        String orderId = this.getParameter(params, "orderId");
        String merchantId = this.getParameter(params, "merchantId");
        String merchantKey = this.getParameter(params, "merchantKey");
        String hash = this.getParameter(params, "hash");
        String isDebug = this.getParameter(params, "isDebug");
        String surl = this.getParameter(params, "surl");
        String furl = this.getParameter(params, "furl");
        String userCredentials = merchantKey + ":" + info.getEmail();
        PaymentParamsUpiSdk paymentParamsUpiSdk = new PaymentParamsUpiSdk();
        paymentParamsUpiSdk.setKey(merchantKey);
        paymentParamsUpiSdk.setProductInfo(product);
        paymentParamsUpiSdk.setFirstName(name);
        paymentParamsUpiSdk.setEmail(info.getEmail());
        paymentParamsUpiSdk.setPhone(info.getContact());
        paymentParamsUpiSdk.setAmount(info.getPayMoney());
        paymentParamsUpiSdk.setTxnId(orderId);
        paymentParamsUpiSdk.setSurl(surl);
        paymentParamsUpiSdk.setFurl(furl);
        paymentParamsUpiSdk.setUdf1("");
        paymentParamsUpiSdk.setUdf2("");
        paymentParamsUpiSdk.setUdf3("");
        paymentParamsUpiSdk.setUdf4("");
        paymentParamsUpiSdk.setUdf5("");
        paymentParamsUpiSdk.setVpa("");
        paymentParamsUpiSdk.setUserCredentials(userCredentials);
        paymentParamsUpiSdk.setHash(hash);
        PayUUPICallback payUUpiSdkCallbackUpiSdk = new PayUUPICallback(){

            public void onPaymentFailure(String payuResult, String merchantResponse) {
                super.onPaymentFailure(payuResult, merchantResponse);
                Bundle bundle = new Bundle();
                bundle.putString("payuResult", payuResult);
                bundle.putString("merchantResponse", merchantResponse);
                PayUmobile.this.mCallback.onPaymentResult("0", bundle);
            }

            public void onPaymentSuccess(String payuResult, String merchantResponse) {
                super.onPaymentSuccess(payuResult, merchantResponse);
                Bundle bundle = new Bundle();
                bundle.putString("payuResult", payuResult);
                bundle.putString("merchantResponse", merchantResponse);
                PayUmobile.this.mCallback.onPaymentResult("1", bundle);
            }

            public void onVpaEntered(String vpa, IValidityCheck iValidityCheck) {
                super.onVpaEntered(vpa, iValidityCheck);
            }
        };
        String postDataFromUpiSdk = new PostDataGenerate.PostDataBuilder((Context)activity).setPaymentMode("upi").setPaymentParamUpiSdk(paymentParamsUpiSdk).build().toString();
        UpiConfig upiConfig = new UpiConfig();
        upiConfig.setMerchantKey(merchantKey);
        upiConfig.setPayuPostData(postDataFromUpiSdk);
        Upi upi = Upi.getInstance();
        upi.makePayment(payUUpiSdkCallbackUpiSdk, activity, upiConfig);
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return false;
        }
        if ("1".equals(status)) {
            return true;
        }
        if ("0".equals(status)) {
            this.showToast(activity, activity.getString(R.string.payment_status_failed));
        }
        return false;
    }

    public void release() {
    }

    private void showToast(Activity activity, String text) {
        Toast.makeText((Context)activity, (CharSequence)text, (int)0).show();
    }
}

