/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.aitime.android.payment.paytm.R;
import com.paytm.pgsdk.PaytmOrder;
import com.paytm.pgsdk.PaytmPaymentTransactionCallback;
import com.paytm.pgsdk.TransactionManager;
import java.util.Map;

@Payment(channel="razorpay")
public class Paytm
implements IPayment {
    private Activity mActivity;
    private IPaymentCallback mCallback;

    public Paytm(Activity activity) {
        this.mActivity = activity;
    }

    public void callback(IPaymentCallback callback) {
        this.mCallback = callback;
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        String orderId = params.get("orderId");
        if (orderId == null || orderId.length() == 0) {
            throw new IllegalArgumentException("The orderId is required.");
        }
        String mid = params.get("mid");
        if (mid == null || mid.length() == 0) {
            throw new IllegalArgumentException("The mid is required.");
        }
        String txnToken = params.get("txnToken");
        if (txnToken == null || txnToken.length() == 0) {
            throw new IllegalArgumentException("The txnToken is required.");
        }
        String callbackUrl = params.get("callbackUrl");
        if (callbackUrl == null || callbackUrl.length() == 0) {
            throw new IllegalArgumentException("The callbackUrl is required.");
        }
        String showPaymentUrl = params.get("showPaymentUrl");
        PaytmPaymentTransactionCallback transactionCallback = new PaytmPaymentTransactionCallback(){

            public void onTransactionResponse(Bundle bundle) {
                Paytm.this.mCallback.onPaymentResult("1", bundle);
            }

            public void networkNotAvailable() {
                Paytm.this.mCallback.onPaymentResult("-1", new Bundle());
            }

            public void onErrorProceed(String s) {
                Bundle bundle = new Bundle();
                bundle.putString("message", s);
                Paytm.this.mCallback.onPaymentResult("-2", bundle);
            }

            public void clientAuthenticationFailed(String s) {
                Bundle bundle = new Bundle();
                bundle.putString("message", s);
                Paytm.this.mCallback.onPaymentResult("-3", bundle);
            }

            public void someUIErrorOccurred(String s) {
                Bundle bundle = new Bundle();
                bundle.putString("message", s);
                Paytm.this.mCallback.onPaymentResult("-4", bundle);
            }

            public void onErrorLoadingWebPage(int i, String s, String s1) {
                Bundle bundle = new Bundle();
                bundle.putString("message", s1);
                Paytm.this.mCallback.onPaymentResult("-5", bundle);
            }

            public void onBackPressedCancelTransaction() {
                Paytm.this.mCallback.onPaymentResult("0", new Bundle());
            }

            public void onTransactionCancel(String s, Bundle bundle) {
                Paytm.this.mCallback.onPaymentResult("0", bundle);
            }
        };
        PaytmOrder paytmOrder = new PaytmOrder(orderId, mid, txnToken, info.getPayMoney(), callbackUrl);
        TransactionManager transactionManager = new TransactionManager(paytmOrder, transactionCallback);
        if (showPaymentUrl != null && showPaymentUrl.length() > 0) {
            transactionManager.setShowPaymentUrl(showPaymentUrl);
        }
        transactionManager.startTransaction(this.mActivity, Math.abs("paytm".hashCode()));
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        if ("1".equals(status)) {
            return true;
        }
        if ("0".equals(status)) {
            this.showToast(R.string.payment_status_cancelled);
            return false;
        }
        if ("-1".equals(status)) {
            this.showToast(R.string.payment_network_error);
            return false;
        }
        String message = bundle.getString("message");
        if (message == null || message.length() == 0) {
            this.showToast(R.string.payment_status_failed);
        } else {
            this.showToast(this.mActivity.getString(R.string.payment_status_failed) + "[" + message + "]");
        }
        return false;
    }

    public void release() {
    }

    private void showToast(@StringRes int resId) {
        Toast.makeText((Context)this.mActivity, (int)resId, (int)0).show();
    }

    private void showToast(String text) {
        Toast.makeText((Context)this.mActivity, (CharSequence)text, (int)0).show();
    }
}

