/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.aitime.android.payment.BrowserLinkUrlHandler;
import com.aitime.android.payment.ILinkUrlHandler;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import java.lang.ref.WeakReference;
import java.util.Map;

@Payment(channel="linkurl")
public class LinkUrl
implements IPayment {
    private final WeakReference<Activity> mActivity;
    private static Class<? extends ILinkUrlHandler> handlerClass = BrowserLinkUrlHandler.class;

    public LinkUrl(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public static void setHandlerClass(@NonNull Class<? extends ILinkUrlHandler> clazz) {
        handlerClass = clazz;
    }

    public void callback(@NonNull IPaymentCallback callback) {
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        String paymentUrl = params.get("paymentUrl");
        if (paymentUrl == null || paymentUrl.length() == 0) {
            throw new IllegalArgumentException("The paymentUrl is required.");
        }
        try {
            handlerClass.newInstance().openLinkUrl(activity, paymentUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        return false;
    }

    public void release() {
        this.mActivity.clear();
    }
}

