package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.core.PayChannel;
import com.aitime.android.payment.entity.PaymentInfo;

import java.lang.ref.WeakReference;
import java.util.Map;

/**
 * LinkUrl payment
 */
@Payment(channel = PayChannel.LINKURL)
public class LinkUrl implements IPayment {

    private final WeakReference<Activity> mActivity;

    private static Class<? extends ILinkUrlHandler> handlerClass = BrowserLinkUrlHandler.class;

    public LinkUrl(Activity activity) {
        this.mActivity = new WeakReference<>(activity);
    }

    public static void setHandlerClass(@NonNull Class<? extends ILinkUrlHandler> clazz) {
        LinkUrl.handlerClass = clazz;
    }

    @Override
    public void callback(@NonNull IPaymentCallback callback) {

    }

    @Override
    public void preload(@NonNull Application application) {

    }

    @Override
    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Activity activity = mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        String paymentUrl = params.get("paymentUrl");
        if (paymentUrl == null || paymentUrl.length() == 0) {
            throw new IllegalArgumentException("The paymentUrl is required.");
        }
        try {
            handlerClass.newInstance().openLinkUrl(activity, paymentUrl);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        return false;
    }

    @Override
    public void release() {
        mActivity.clear();
    }

}
